/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.resource.Resource;
import io.inverno.mod.base.resource.ZipResource;
import io.inverno.mod.http.base.InternalServerErrorException;
import io.inverno.mod.http.base.NotFoundException;
import io.inverno.mod.http.server.ResponseBody;
import io.inverno.mod.http.server.internal.AbstractResponseBody;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseHeaders;
import io.netty.buffer.ByteBuf;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.FileRegion;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Objects;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

class Http1xResponseBody
extends AbstractResponseBody<Http1xResponseHeaders, Http1xResponseBody> {
    private static final int MAX_FILE_REGION_SIZE = 0x100000;
    private final boolean supportsFileRegion;
    private Publisher<FileRegion> fileRegionData;

    public Http1xResponseBody(Http1xResponseHeaders headers, boolean supportsFileRegion) {
        super(headers);
        this.supportsFileRegion = supportsFileRegion;
    }

    public Publisher<FileRegion> getFileRegionData() {
        return this.fileRegionData;
    }

    @Override
    protected void setData(Publisher<ByteBuf> data) throws IllegalStateException {
        super.setData(data);
        this.fileRegionData = null;
    }

    @Override
    public ResponseBody.Resource resource() {
        if (this.resourceData == null) {
            this.resourceData = new FileRegionResourceOutboundData();
        }
        return this.resourceData;
    }

    protected class FileRegionResourceOutboundData
    extends AbstractResponseBody.ResourceOutboundData {
        protected FileRegionResourceOutboundData() {
            super(Http1xResponseBody.this);
        }

        @Override
        public void value(Resource resource) {
            Objects.requireNonNull(resource);
            if (resource.exists().orElse(true).booleanValue()) {
                this.populateHeaders(resource);
                if (Http1xResponseBody.this.supportsFileRegion && resource.isFile().orElse(false).booleanValue() && !(resource instanceof ZipResource)) {
                    Http1xResponseBody.this.setData((Publisher<ByteBuf>)Flux.empty());
                    FileChannel fileChannel = (FileChannel)resource.openReadableByteChannel().orElseThrow(() -> new InternalServerErrorException("Resource is not readable: " + String.valueOf(resource.getURI())));
                    long size = (Long)resource.size().get();
                    int count = (int)Math.ceil((float)size / 1048576.0f);
                    Http1xResponseBody.this.fileRegionData = Flux.range((int)0, (int)(count + 1)).filter(index -> index < count).map(index -> {
                        long position = index * 0x100000;
                        DefaultFileRegion region = new DefaultFileRegion(fileChannel, position, Math.min(size - position, 0x100000L));
                        region.retain();
                        return region;
                    }).doOnDiscard(FileRegion.class, ReferenceCounted::release).doFinally(sgn -> {
                        try {
                            fileChannel.close();
                        }
                        catch (IOException e) {
                            throw Exceptions.propagate((Throwable)e);
                        }
                    });
                } else {
                    Http1xResponseBody.this.setData((Publisher<ByteBuf>)resource.read());
                }
            } else {
                throw new NotFoundException();
            }
        }
    }
}

