/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.Charsets;
import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.internal.header.HeadersValidator;
import io.inverno.mod.http.base.internal.netty.FlatFullHttpResponse;
import io.inverno.mod.http.base.internal.netty.FlatHttpResponse;
import io.inverno.mod.http.base.internal.netty.FlatLastHttpContent;
import io.inverno.mod.http.base.internal.netty.LinkedHttpHeaders;
import io.inverno.mod.http.server.internal.AbstractResponse;
import io.inverno.mod.http.server.internal.http1x.Http1xConnection;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseBody;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseHeaders;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseTrailers;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.charset.Charset;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class Http1xResponse
extends AbstractResponse<Http1xResponseHeaders, Http1xResponseBody, Http1xResponseTrailers, Http1xResponse> {
    private final HeadersValidator headersValidator;
    private final Http1xConnection connection;
    private final HttpVersion version;
    private final Http1xResponseBody body;
    private Http1xResponseTrailers trailers;
    private Disposable disposable;

    public Http1xResponse(HeaderService headerService, ObjectConverter<String> parameterConverter, HeadersValidator headersValidator, Http1xConnection connection, HttpVersion version, boolean head, boolean keepAlive) {
        super(headerService, parameterConverter, head, new Http1xResponseHeaders(headerService, parameterConverter, headersValidator));
        this.headersValidator = headersValidator;
        this.connection = connection;
        this.version = version;
        if (version == HttpVersion.HTTP_1_0) {
            if (keepAlive) {
                ((Http1xResponseHeaders)this.headers).set("connection", "keep-alive");
            }
        } else if (!keepAlive) {
            ((Http1xResponseHeaders)this.headers).set("connection", "close");
        }
        this.body = new Http1xResponseBody((Http1xResponseHeaders)this.headers, connection.supportsFileRegion());
    }

    @Override
    public void send() {
        if (this.connection.executor().inEventLoop()) {
            if (!this.head) {
                if (this.body.getFileRegionData() == null) {
                    this.body.getData().subscribe((Subscriber)(this.body.getData() instanceof Mono ? new MonoBodyDataSubscriber() : new BodyDataSubscriber()));
                } else {
                    Flux.concat((Publisher[])new Publisher[]{this.body.getFileRegionData(), Flux.from(this.body.getData()).cast(FileRegion.class)}).subscribe((CoreSubscriber)new FileRegionBodyDataSubscriber());
                }
            } else {
                LinkedHttpHeaders httpTrailers;
                ((Http1xResponseHeaders)this.headers).remove("transfer-encoding");
                HttpResponseStatus httpStatus = HttpResponseStatus.valueOf((int)((Http1xResponseHeaders)this.headers).getStatusCode());
                if (httpStatus == HttpResponseStatus.NOT_MODIFIED || httpStatus == HttpResponseStatus.NO_CONTENT) {
                    httpTrailers = null;
                } else {
                    LinkedHttpHeaders linkedHttpHeaders = httpTrailers = this.trailers != null ? this.trailers.unwrap() : null;
                    if (httpTrailers != null) {
                        ((Http1xResponseHeaders)this.headers).set("trailer", httpTrailers.names().stream().collect(Collectors.joining(", ")));
                    }
                }
                this.connection.writeHttpObject((HttpObject)new FlatFullHttpResponse(this.version, httpStatus, (HttpHeaders)((Http1xResponseHeaders)this.headers).unwrap(), Unpooled.EMPTY_BUFFER, (HttpHeaders)httpTrailers));
                if (httpTrailers != null) {
                    this.trailers.setWritten();
                }
                this.connection.onExchangeComplete();
            }
        } else {
            this.connection.executor().execute(this::send);
        }
    }

    final void dispose(Throwable cause) {
        if (this.disposable != null) {
            this.disposable.dispose();
            this.disposable = null;
        }
    }

    @Override
    public Http1xResponse sendContinue() throws IllegalStateException {
        if (this.isHeadersWritten()) {
            throw new IllegalStateException("Headers already written");
        }
        if (this.connection.executor().inEventLoop()) {
            this.connection.writeHttpObject((HttpObject)new DefaultFullHttpResponse(this.version, HttpResponseStatus.CONTINUE));
        } else {
            this.connection.executor().execute(this::sendContinue);
        }
        return this;
    }

    @Override
    public Http1xResponseBody body() {
        return this.body;
    }

    @Override
    public Http1xResponseTrailers trailers() {
        if (this.trailers == null) {
            this.trailers = new Http1xResponseTrailers(this.headerService, (ObjectConverter<String>)this.parameterConverter, this.headersValidator);
        }
        return this.trailers;
    }

    private class MonoBodyDataSubscriber
    extends BaseSubscriber<ByteBuf> {
        private ByteBuf data;

        private MonoBodyDataSubscriber() {
        }

        protected void hookOnSubscribe(Subscription subscription) {
            Http1xResponse.this.disposable = this;
            subscription.request(1L);
        }

        protected void hookOnNext(ByteBuf value) {
            Http1xResponse.this.transferedLength += value.readableBytes();
            this.data = value;
        }

        protected void hookOnComplete() {
            EmptyHttpHeaders httpTrailers;
            HttpResponseStatus httpStatus = HttpResponseStatus.valueOf((int)((Http1xResponseHeaders)Http1xResponse.this.headers).getStatusCode());
            if (httpStatus == HttpResponseStatus.NOT_MODIFIED || httpStatus == HttpResponseStatus.NO_CONTENT) {
                ((Http1xResponseHeaders)Http1xResponse.this.headers).remove("transfer-encoding");
                httpTrailers = null;
            } else {
                if (!((Http1xResponseHeaders)Http1xResponse.this.headers).contains("content-length")) {
                    ((Http1xResponseHeaders)Http1xResponse.this.headers).set("content-length", "" + Http1xResponse.this.transferedLength);
                }
                if (Http1xResponse.this.trailers == null) {
                    httpTrailers = EmptyHttpHeaders.INSTANCE;
                } else {
                    httpTrailers = Http1xResponse.this.trailers.unwrap();
                    ((Http1xResponseHeaders)Http1xResponse.this.headers).set("trailer", httpTrailers.names().stream().collect(Collectors.joining(", ")));
                }
            }
            if (this.data == null) {
                Http1xResponse.this.connection.writeHttpObject((HttpObject)new FlatFullHttpResponse(Http1xResponse.this.version, httpStatus, (HttpHeaders)((Http1xResponseHeaders)Http1xResponse.this.headers).unwrap(), Unpooled.EMPTY_BUFFER, (HttpHeaders)httpTrailers));
            } else {
                Http1xResponse.this.connection.writeHttpObject((HttpObject)new FlatFullHttpResponse(Http1xResponse.this.version, httpStatus, (HttpHeaders)((Http1xResponseHeaders)Http1xResponse.this.headers).unwrap(), this.data, (HttpHeaders)httpTrailers));
            }
            ((Http1xResponseHeaders)Http1xResponse.this.headers).setWritten();
            if (Http1xResponse.this.trailers != null) {
                Http1xResponse.this.trailers.setWritten();
            }
            Http1xResponse.this.connection.onExchangeComplete();
        }

        protected void hookOnError(Throwable throwable) {
            Http1xResponse.this.connection.onExchangeError(throwable);
        }
    }

    private class BodyDataSubscriber
    extends BaseSubscriber<ByteBuf> {
        private HttpResponseStatus httpStatus;
        private HttpHeaders httpTrailers;
        private ByteBuf singleChunk;
        private boolean many;
        private boolean sse;
        private Charset charset;

        private BodyDataSubscriber() {
        }

        private void sanitizeResponse() {
            this.httpStatus = HttpResponseStatus.valueOf((int)((Http1xResponseHeaders)Http1xResponse.this.headers).getStatusCode());
            if (this.httpStatus == HttpResponseStatus.NOT_MODIFIED || this.httpStatus == HttpResponseStatus.NO_CONTENT) {
                ((Http1xResponseHeaders)Http1xResponse.this.headers).remove("transfer-encoding");
                this.httpTrailers = null;
            } else {
                if (!((Http1xResponseHeaders)Http1xResponse.this.headers).contains("content-length")) {
                    List<String> transferEncodings = ((Http1xResponseHeaders)Http1xResponse.this.headers).getAll("transfer-encoding");
                    if (!(this.many || !transferEncodings.isEmpty() && transferEncodings.getLast().endsWith("chunked"))) {
                        ((Http1xResponseHeaders)Http1xResponse.this.headers).set("content-length", "" + Http1xResponse.this.transferedLength);
                    } else {
                        if (transferEncodings.isEmpty()) {
                            ((Http1xResponseHeaders)Http1xResponse.this.headers).add("transfer-encoding", "chunked");
                        }
                        ((Http1xResponseHeaders)Http1xResponse.this.headers).get("content-type").ifPresent(contentType -> {
                            this.sse = contentType.regionMatches(true, 0, "text/event-stream", 0, "text/event-stream".length());
                        });
                    }
                }
                if (Http1xResponse.this.trailers == null) {
                    this.httpTrailers = EmptyHttpHeaders.INSTANCE;
                } else {
                    this.httpTrailers = Http1xResponse.this.trailers.unwrap();
                    ((Http1xResponseHeaders)Http1xResponse.this.headers()).set("trailer", this.httpTrailers.names().stream().collect(Collectors.joining(", ")));
                }
            }
        }

        private Charset getCharset() {
            if (Http1xResponse.this.isHeadersWritten()) {
                this.charset = ((Http1xResponseHeaders)Http1xResponse.this.headers).getHeader("content-type").map(Headers.ContentType::getCharset).orElse(Charsets.DEFAULT);
            }
            if (this.charset == null) {
                return ((Http1xResponseHeaders)Http1xResponse.this.headers).getHeader("content-type").map(Headers.ContentType::getCharset).orElse(Charsets.DEFAULT);
            }
            return this.charset;
        }

        protected void hookOnSubscribe(Subscription subscription) {
            Http1xResponse.this.disposable = this;
            subscription.request(Long.MAX_VALUE);
        }

        protected void hookOnNext(ByteBuf value) {
            Http1xResponse.this.transferedLength += value.readableBytes();
            if (!this.many && this.singleChunk == null) {
                this.singleChunk = value;
            } else {
                ByteBuf chunked_trailer;
                ByteBuf chunked_header;
                this.many = true;
                if (!((Http1xResponseHeaders)Http1xResponse.this.headers).isWritten()) {
                    this.sanitizeResponse();
                    if (this.sse) {
                        chunked_header = Unpooled.copiedBuffer((CharSequence)(Integer.toHexString(this.singleChunk.readableBytes()) + "\r\n"), (Charset)Charsets.orDefault((Charset)this.getCharset()));
                        chunked_trailer = Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)Charsets.orDefault((Charset)this.getCharset()));
                        Http1xResponse.this.connection.writeHttpObject((HttpObject)new FlatHttpResponse(Http1xResponse.this.version, this.httpStatus, (HttpHeaders)((Http1xResponseHeaders)Http1xResponse.this.headers).unwrap(), Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{chunked_header, this.singleChunk, chunked_trailer})));
                    } else {
                        Http1xResponse.this.connection.writeHttpObject((HttpObject)new FlatHttpResponse(Http1xResponse.this.version, this.httpStatus, (HttpHeaders)((Http1xResponseHeaders)Http1xResponse.this.headers).unwrap(), this.singleChunk));
                    }
                    this.singleChunk = null;
                    ((Http1xResponseHeaders)Http1xResponse.this.headers).setWritten();
                }
                if (this.sse) {
                    chunked_header = Unpooled.copiedBuffer((CharSequence)(Integer.toHexString(value.readableBytes()) + "\r\n"), (Charset)Charsets.orDefault((Charset)this.getCharset()));
                    chunked_trailer = Unpooled.copiedBuffer((CharSequence)"\r\n", (Charset)Charsets.orDefault((Charset)this.getCharset()));
                    Http1xResponse.this.connection.writeHttpObject((HttpObject)new DefaultHttpContent(Unpooled.wrappedBuffer((ByteBuf[])new ByteBuf[]{chunked_header, value, chunked_trailer})));
                } else {
                    Http1xResponse.this.connection.writeHttpObject((HttpObject)new DefaultHttpContent(value));
                }
            }
        }

        protected void hookOnComplete() {
            if (this.many) {
                if (Http1xResponse.this.trailers == null) {
                    Http1xResponse.this.connection.writeHttpObject((HttpObject)LastHttpContent.EMPTY_LAST_CONTENT);
                } else {
                    Http1xResponse.this.connection.writeHttpObject((HttpObject)new FlatLastHttpContent(Unpooled.EMPTY_BUFFER, this.httpTrailers));
                    Http1xResponse.this.trailers.setWritten();
                }
            } else {
                this.sanitizeResponse();
                if (this.singleChunk == null) {
                    Http1xResponse.this.connection.writeHttpObject((HttpObject)new FlatFullHttpResponse(Http1xResponse.this.version, this.httpStatus, (HttpHeaders)((Http1xResponseHeaders)Http1xResponse.this.headers).unwrap(), Unpooled.EMPTY_BUFFER, this.httpTrailers));
                } else {
                    Http1xResponse.this.connection.writeHttpObject((HttpObject)new FlatFullHttpResponse(Http1xResponse.this.version, this.httpStatus, (HttpHeaders)((Http1xResponseHeaders)Http1xResponse.this.headers).unwrap(), this.singleChunk, this.httpTrailers));
                    this.singleChunk = null;
                }
                ((Http1xResponseHeaders)Http1xResponse.this.headers).setWritten();
                if (Http1xResponse.this.trailers != null) {
                    Http1xResponse.this.trailers.setWritten();
                }
            }
            Http1xResponse.this.connection.onExchangeComplete();
        }

        protected void hookOnCancel() {
            if (this.singleChunk != null) {
                this.singleChunk.release();
            }
        }

        protected void hookOnError(Throwable throwable) {
            Http1xResponse.this.connection.onExchangeError(throwable);
        }
    }

    private class FileRegionBodyDataSubscriber
    extends BaseSubscriber<FileRegion> {
        private HttpHeaders httpTrailers;

        private FileRegionBodyDataSubscriber() {
        }

        protected void hookOnSubscribe(Subscription subscription) {
            HttpResponseStatus httpStatus = HttpResponseStatus.valueOf((int)((Http1xResponseHeaders)Http1xResponse.this.headers).getStatusCode());
            if (httpStatus == HttpResponseStatus.NOT_MODIFIED || httpStatus == HttpResponseStatus.NO_CONTENT) {
                ((Http1xResponseHeaders)Http1xResponse.this.headers).remove("transfer-encoding");
                this.httpTrailers = null;
            } else if (Http1xResponse.this.trailers == null) {
                this.httpTrailers = EmptyHttpHeaders.INSTANCE;
            } else {
                this.httpTrailers = Http1xResponse.this.trailers.unwrap();
                ((Http1xResponseHeaders)Http1xResponse.this.headers).set("trailer", this.httpTrailers.names().stream().collect(Collectors.joining(", ")));
            }
            Http1xResponse.this.connection.writeHttpObject((HttpObject)new FlatHttpResponse(Http1xResponse.this.version, httpStatus, (HttpHeaders)((Http1xResponseHeaders)Http1xResponse.this.headers).unwrap(), Unpooled.EMPTY_BUFFER));
            ((Http1xResponseHeaders)Http1xResponse.this.headers).setWritten();
            subscription.request(1L);
        }

        protected void hookOnNext(FileRegion value) {
            Http1xResponse.this.transferedLength = (int)((long)Http1xResponse.this.transferedLength + value.count());
            Http1xResponse.this.connection.writeFileRegion(value, Http1xResponse.this.connection.newPromise().addListener(future -> {
                if (future.isSuccess()) {
                    this.request(1L);
                } else {
                    Http1xResponse.this.connection.onExchangeError(future.cause());
                }
            }));
        }

        protected void hookOnComplete() {
            if (Http1xResponse.this.trailers == null) {
                Http1xResponse.this.connection.writeHttpObject((HttpObject)LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                Http1xResponse.this.connection.writeHttpObject((HttpObject)new FlatLastHttpContent(Unpooled.EMPTY_BUFFER, this.httpTrailers));
                Http1xResponse.this.trailers.setWritten();
            }
            Http1xResponse.this.connection.onExchangeComplete();
        }

        protected void hookOnError(Throwable throwable) {
            Http1xResponse.this.connection.onExchangeError(throwable);
        }
    }
}

