/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.internal.GenericParameter;
import io.inverno.mod.http.base.internal.netty.LinkedHttpHeaders;
import io.inverno.mod.http.server.internal.AbstractRequestHeaders;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

class Http1xRequestHeaders
extends AbstractRequestHeaders {
    private final LinkedHttpHeaders headers;

    public Http1xRequestHeaders(HeaderService headerService, ObjectConverter<String> parameterConverter, LinkedHttpHeaders headers) {
        super(headerService, parameterConverter);
        this.headers = headers;
    }

    public String getContentType() {
        return this.headers.get((CharSequence)"content-type");
    }

    public Headers.ContentType getContentTypeHeader() {
        return this.getHeader("content-type").orElse(null);
    }

    public Long getContentLength() {
        return this.headers.getLong((CharSequence)"content-length");
    }

    public boolean contains(CharSequence name) {
        return this.headers.contains(name);
    }

    public boolean contains(CharSequence name, CharSequence value) {
        return this.headers.contains(name, value, true);
    }

    public Set<String> getNames() {
        return this.headers.names();
    }

    public Optional<String> get(CharSequence name) {
        return Optional.ofNullable(this.headers.get(name));
    }

    public List<String> getAll(CharSequence name) {
        return this.headers.getAll(name);
    }

    public List<Map.Entry<String, String>> getAll() {
        return this.headers.entries();
    }

    public Optional<Parameter> getParameter(CharSequence name) {
        return this.get(name).map(value -> new GenericParameter(name.toString(), value, this.parameterConverter));
    }

    public List<Parameter> getAllParameter(CharSequence name) {
        return this.headers.getAll(name).stream().map(value -> new GenericParameter(name.toString(), value, this.parameterConverter)).collect(Collectors.toList());
    }

    public List<Parameter> getAllParameter() {
        return this.headers.entries().stream().map(e -> new GenericParameter((String)e.getKey(), (String)e.getValue(), this.parameterConverter)).collect(Collectors.toList());
    }

    public <T extends Header> Optional<T> getHeader(CharSequence name) {
        return this.get(name).map(value -> this.headerService.decode(name.toString(), value));
    }

    public <T extends Header> List<T> getAllHeader(CharSequence name) {
        return this.headers.getAll(name).stream().map(value -> this.headerService.decode(name.toString(), value)).collect(Collectors.toList());
    }

    public List<Header> getAllHeader() {
        return this.headers.entries().stream().map(e -> this.headerService.decode((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
    }
}

