/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Method;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.internal.netty.LinkedHttpHeaders;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.internal.AbstractRequest;
import io.inverno.mod.http.server.internal.http1x.Http1xConnection;
import io.inverno.mod.http.server.internal.http1x.Http1xRequestBody;
import io.inverno.mod.http.server.internal.http1x.Http1xRequestHeaders;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.netty.handler.codec.http.HttpRequest;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.Optional;

class Http1xRequest
extends AbstractRequest<Http1xRequestHeaders, Http1xRequestBody> {
    private final Http1xConnection connection;
    private final HttpRequest request;
    private String scheme;
    private Method method;
    private String authority;

    public Http1xRequest(HeaderService headerService, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder, Http1xConnection connection, HttpRequest request) {
        super(parameterConverter, urlEncodedBodyDecoder, multipartBodyDecoder, new Http1xRequestHeaders(headerService, parameterConverter, (LinkedHttpHeaders)request.headers()));
        this.connection = connection;
        this.request = request;
    }

    HttpRequest unwrap() {
        return this.request;
    }

    public String getScheme() {
        if (this.scheme == null) {
            this.scheme = this.connection.isTls() ? "https" : "http";
        }
        return this.scheme;
    }

    public SocketAddress getLocalAddress() {
        return this.connection.getLocalAddress();
    }

    public Optional<Certificate[]> getLocalCertificates() {
        return this.connection.getLocalCertificates();
    }

    public SocketAddress getRemoteAddress() {
        return this.connection.getRemoteAddress();
    }

    public Optional<Certificate[]> getRemoteCertificates() {
        return this.connection.getRemoteCertificates();
    }

    public Method getMethod() {
        if (this.method == null) {
            try {
                this.method = Method.valueOf((String)this.request.method().name());
            }
            catch (IllegalArgumentException e) {
                this.method = Method.UNKNOWN;
            }
        }
        return this.method;
    }

    public String getPath() {
        return this.request.uri();
    }

    public String getAuthority() {
        if (this.authority == null) {
            this.authority = this.request.headers().get((CharSequence)"host");
        }
        return this.authority;
    }

    @Override
    public Optional<Http1xRequestBody> body() {
        if (this.body == null) {
            switch (this.getMethod()) {
                case POST: 
                case PUT: 
                case PATCH: 
                case DELETE: {
                    this.body = new Http1xRequestBody((MultipartDecoder<Parameter>)this.urlEncodedBodyDecoder, (MultipartDecoder<Part>)this.multipartBodyDecoder, (Http1xRequestHeaders)this.headers);
                }
            }
        }
        return Optional.ofNullable((Http1xRequestBody)this.body);
    }
}

