/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.internal.header.HeadersValidator;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.ServerController;
import io.inverno.mod.http.server.internal.http1x.AbstractHttp1xExchange;
import io.inverno.mod.http.server.internal.http1x.Http1xConnection;
import io.inverno.mod.http.server.internal.http1x.Http1xErrorExchange;
import io.inverno.mod.http.server.internal.http1x.Http1xRequest;
import io.inverno.mod.http.server.internal.http1x.Http1xResponse;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseHeaders;
import io.inverno.mod.http.server.internal.http1x.Http1xWebSocket;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.inverno.mod.http.server.ws.WebSocket;
import io.inverno.mod.http.server.ws.WebSocketExchange;
import io.netty.handler.codec.http.HttpRequest;
import java.util.Optional;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Mono;

class Http1xExchange
extends AbstractHttp1xExchange {
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;
    private final HeadersValidator headersValidator;
    private final ExchangeContext context;
    private final Http1xRequest request;
    private final Http1xResponse response;
    private Http1xWebSocket webSocket;
    private Disposable disposable;

    public Http1xExchange(HttpServerConfiguration configuration, ServerController<ExchangeContext, Exchange<ExchangeContext>, ErrorExchange<ExchangeContext>> controller, HeaderService headerService, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder, HeadersValidator headersValidator, Http1xConnection connection, HttpRequest request) {
        super(configuration, controller, connection, request);
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.headersValidator = headersValidator;
        this.context = controller.createContext();
        if (this.context != null) {
            this.context.init();
        }
        this.request = new Http1xRequest(headerService, parameterConverter, urlEncodedBodyDecoder, multipartBodyDecoder, connection, request);
        this.response = new Http1xResponse(headerService, parameterConverter, headersValidator, connection, this.version, this.head, this.keepAlive);
    }

    @Override
    Http1xExchange unwrap() {
        return this;
    }

    @Override
    public void start() {
        try {
            this.controller.defer(this).subscribe((CoreSubscriber)new ExchangeHandlerSubscriber());
        }
        catch (Throwable throwable) {
            this.handleError(throwable);
        }
    }

    @Override
    public void handleError(Throwable throwable) {
        if (((Http1xResponseHeaders)this.response.headers()).isWritten()) {
            this.dispose(throwable);
            this.connection.shutdown().subscribe();
        } else {
            this.createErrorExchange(throwable).start();
        }
    }

    public void handleWebSocketHandshakeError(Throwable throwable, Mono<Void> fallback) {
        if (this.connection.executor().inEventLoop()) {
            if (fallback != null) {
                fallback.subscribe((CoreSubscriber)new ExchangeHandlerSubscriber());
            } else {
                this.handleError(throwable);
            }
        } else {
            this.connection.executor().execute(() -> this.handleWebSocketHandshakeError(throwable, fallback));
        }
    }

    @Override
    public Http1xErrorExchange createErrorExchange(Throwable throwable) {
        return new Http1xErrorExchange(this, new Http1xResponse(this.headerService, this.parameterConverter, this.headersValidator, this.connection, this.version, this.head, this.keepAlive), throwable);
    }

    @Override
    protected void doDispose(Throwable cause) {
        if (this.disposable != null) {
            this.disposable.dispose();
        }
        this.request.dispose(cause);
        this.response.dispose(cause);
        if (this.webSocket != null) {
            this.webSocket.dispose(cause);
        }
    }

    public ExchangeContext context() {
        return this.context;
    }

    @Override
    public Http1xRequest request() {
        return this.request;
    }

    @Override
    public Http1xResponse response() {
        return this.response;
    }

    @Override
    public Optional<? extends WebSocket<ExchangeContext, ? extends WebSocketExchange<ExchangeContext>>> webSocket(String ... subProtocols) {
        if (this.configuration.ws_enabled()) {
            this.webSocket = new Http1xWebSocket(this.configuration, this.connection, this, subProtocols);
            return Optional.of(this.webSocket);
        }
        return Optional.empty();
    }

    private class ExchangeHandlerSubscriber
    extends BaseSubscriber<Void> {
        private ExchangeHandlerSubscriber() {
        }

        protected void hookOnSubscribe(Subscription subscription) {
            Http1xExchange.this.disposable = this;
            subscription.request(1L);
        }

        protected void hookOnComplete() {
            if (Http1xExchange.this.reset) {
                return;
            }
            if (Http1xExchange.this.webSocket == null) {
                Http1xExchange.this.response.send();
            } else {
                Http1xExchange.this.webSocket.connect();
            }
        }

        protected void hookOnError(Throwable throwable) {
            if (!Http1xExchange.this.reset) {
                Http1xExchange.this.connection.onExchangeError(throwable);
            }
        }
    }
}

