/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.HttpException;
import io.inverno.mod.http.base.Status;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.internal.GenericErrorExchangeHandler;
import io.inverno.mod.http.server.internal.http1x.AbstractHttp1xExchange;
import io.inverno.mod.http.server.internal.http1x.Http1xExchange;
import io.inverno.mod.http.server.internal.http1x.Http1xRequest;
import io.inverno.mod.http.server.internal.http1x.Http1xResponse;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseHeaders;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.Disposable;
import reactor.core.publisher.BaseSubscriber;

class Http1xErrorExchange
extends AbstractHttp1xExchange
implements ErrorExchange<ExchangeContext> {
    private static final Logger LOGGER = LogManager.getLogger(ErrorExchange.class);
    private final Http1xExchange exchange;
    private final Http1xResponse response;
    private final Throwable error;
    private boolean lastResort;
    private Disposable disposable;

    public Http1xErrorExchange(Http1xExchange exchange, Http1xResponse response, Throwable error) {
        super(exchange);
        this.exchange = exchange;
        this.response = response;
        this.error = error;
        this.lastResort = false;
    }

    @Override
    Http1xExchange unwrap() {
        return this.exchange;
    }

    @Override
    public void start() {
        this.connection.respondingExchange = this;
        try {
            ErrorExchangeHandlerSubscriber handlerSubscriber = new ErrorExchangeHandlerSubscriber();
            if (this.lastResort) {
                GenericErrorExchangeHandler.INSTANCE.handle(this);
                handlerSubscriber.hookOnComplete();
            } else {
                LOGGER.log(this.error instanceof HttpException && ((HttpException)this.error).getStatusCategory() != Status.Category.SERVER_ERROR ? Level.WARN : Level.ERROR, "Exchange processing error", this.error);
                this.controller.defer(this).subscribe((CoreSubscriber)handlerSubscriber);
            }
        }
        catch (Throwable throwable) {
            this.handleError(throwable);
        }
    }

    @Override
    public void handleError(Throwable throwable) {
        if (this.lastResort || ((Http1xResponseHeaders)this.response.headers()).isWritten()) {
            throwable.addSuppressed(this.error);
            LOGGER.error("Fatal exchange processing error", throwable);
            this.dispose(throwable);
            this.connection.shutdown().subscribe();
        } else {
            LOGGER.error("Error handler error", throwable);
            this.createErrorExchange(throwable).start();
        }
    }

    @Override
    public Http1xErrorExchange createErrorExchange(Throwable throwable) {
        throwable.addSuppressed(this.error);
        Http1xErrorExchange errorExchange = this.exchange.createErrorExchange(throwable);
        errorExchange.lastResort = true;
        return errorExchange;
    }

    @Override
    protected void doDispose(Throwable cause) {
        if (this.disposable != null) {
            this.disposable.dispose();
        }
        this.exchange.request().dispose(cause);
        this.response.dispose(cause);
    }

    @Override
    public Throwable getError() {
        return this.error;
    }

    public ExchangeContext context() {
        return this.exchange.context();
    }

    @Override
    public Http1xRequest request() {
        return this.exchange.request();
    }

    @Override
    public Http1xResponse response() {
        return this.response;
    }

    private class ErrorExchangeHandlerSubscriber
    extends BaseSubscriber<Void> {
        private ErrorExchangeHandlerSubscriber() {
        }

        protected void hookOnSubscribe(Subscription subscription) {
            Http1xErrorExchange.this.disposable = this;
            subscription.request(1L);
        }

        protected void hookOnComplete() {
            if (!Http1xErrorExchange.this.reset) {
                Http1xErrorExchange.this.response.send();
            }
        }

        protected void hookOnError(Throwable throwable) {
            if (!Http1xErrorExchange.this.reset) {
                Http1xErrorExchange.this.connection.onExchangeError(throwable);
            }
        }
    }
}

