/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.core.annotation.Bean;
import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.internal.header.HeadersValidator;
import io.inverno.mod.http.base.internal.ws.GenericWebSocketFrame;
import io.inverno.mod.http.base.internal.ws.GenericWebSocketMessage;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.ServerController;
import io.inverno.mod.http.server.internal.http1x.Http1xConnection;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import java.util.function.Supplier;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class Http1xConnectionFactory
implements Supplier<Http1xConnection> {
    private final HttpServerConfiguration configuration;
    private final ServerController<ExchangeContext, Exchange<ExchangeContext>, ErrorExchange<ExchangeContext>> controller;
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;
    private final MultipartDecoder<Parameter> urlEncodedBodyDecoder;
    private final MultipartDecoder<Part> multipartBodyDecoder;
    private final HeadersValidator headersValidator;
    private final GenericWebSocketFrame.GenericFactory webSocketFrameFactory;
    private final GenericWebSocketMessage.GenericFactory webSocketMessageFactory;

    public Http1xConnectionFactory(HttpServerConfiguration configuration, ServerController<?, ? extends Exchange<?>, ? extends ErrorExchange<?>> controller, HeaderService headerService, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder) {
        this.configuration = configuration;
        this.controller = controller;
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.urlEncodedBodyDecoder = urlEncodedBodyDecoder;
        this.multipartBodyDecoder = multipartBodyDecoder;
        Object object = this.headersValidator = configuration.http1x_validate_headers() ? HeadersValidator.DEFAULT_HTTP1X_HEADERS_VALIDATOR : null;
        if (configuration.ws_enabled()) {
            this.webSocketFrameFactory = new GenericWebSocketFrame.GenericFactory(configuration.ws_max_frame_size().intValue());
            this.webSocketMessageFactory = new GenericWebSocketMessage.GenericFactory(configuration.ws_max_frame_size().intValue());
        } else {
            this.webSocketFrameFactory = null;
            this.webSocketMessageFactory = null;
        }
    }

    @Override
    public Http1xConnection get() {
        return new Http1xConnection(this.configuration, this.controller, this.headerService, this.parameterConverter, this.urlEncodedBodyDecoder, this.multipartBodyDecoder, this.webSocketFrameFactory, this.webSocketMessageFactory, this.headersValidator);
    }
}

