/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.HttpVersion;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.internal.header.HeadersValidator;
import io.inverno.mod.http.base.internal.ws.GenericWebSocketFrame;
import io.inverno.mod.http.base.internal.ws.GenericWebSocketMessage;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.HttpServerException;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.ServerController;
import io.inverno.mod.http.server.internal.HttpConnection;
import io.inverno.mod.http.server.internal.http1x.AbstractHttp1xExchange;
import io.inverno.mod.http.server.internal.http1x.Http1xExchange;
import io.inverno.mod.http.server.internal.http1x.Http1xRequest;
import io.inverno.mod.http.server.internal.http1x.Http1xRequestBody;
import io.inverno.mod.http.server.internal.http1x.Http1xResponse;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseHeaders;
import io.inverno.mod.http.server.internal.http1x.ws.GenericWebSocketExchange;
import io.inverno.mod.http.server.internal.http1x.ws.WebSocketConnection;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.TooLongHttpHeaderException;
import io.netty.handler.codec.http.TooLongHttpLineException;
import io.netty.handler.codec.http.websocketx.CorruptedWebSocketFrameException;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerProtocolConfig;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandler;
import io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.DeflateFrameServerExtensionHandshaker;
import io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ScheduledFuture;
import java.net.SocketAddress;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.core.scheduler.Schedulers;

public class Http1xConnection
extends ChannelDuplexHandler
implements HttpConnection {
    private static final Logger LOGGER = LogManager.getLogger(HttpConnection.class);
    private final HttpServerConfiguration configuration;
    private final ServerController<ExchangeContext, Exchange<ExchangeContext>, ErrorExchange<ExchangeContext>> controller;
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;
    private final MultipartDecoder<Parameter> urlEncodedBodyDecoder;
    private final MultipartDecoder<Part> multipartBodyDecoder;
    private final GenericWebSocketFrame.GenericFactory webSocketFrameFactory;
    private final GenericWebSocketMessage.GenericFactory webSocketMessageFactory;
    private final HeadersValidator headersValidator;
    private ChannelHandlerContext channelContext;
    private boolean tls;
    private boolean supportsFileRegion;
    private Http1xExchange requestingExchange;
    AbstractHttp1xExchange respondingExchange;
    private Throwable decoderError;
    private boolean read;
    private boolean flush;
    private Sinks.One<Void> shutdownSink;
    private Mono<Void> shutdown;
    private Sinks.One<Void> gracefulShutdownSink;
    private Mono<Void> gracefulShutdown;
    private ScheduledFuture<?> gracefulShutdownTimeout;
    private ChannelPromise gracefulShutdownClosePromise;
    private boolean closing;
    private boolean closed;

    Http1xConnection(HttpServerConfiguration configuration, ServerController<ExchangeContext, Exchange<ExchangeContext>, ErrorExchange<ExchangeContext>> controller, HeaderService headerService, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder, GenericWebSocketFrame.GenericFactory webSocketFrameFactory, GenericWebSocketMessage.GenericFactory webSocketMessageFactory, HeadersValidator headersValidator) {
        this.configuration = configuration;
        this.controller = controller;
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.urlEncodedBodyDecoder = urlEncodedBodyDecoder;
        this.multipartBodyDecoder = multipartBodyDecoder;
        this.webSocketFrameFactory = webSocketFrameFactory;
        this.webSocketMessageFactory = webSocketMessageFactory;
        this.headersValidator = headersValidator;
    }

    public EventExecutor executor() {
        return this.channelContext.executor();
    }

    public ChannelPromise newPromise() {
        return this.channelContext.newPromise();
    }

    public ChannelPromise voidPromise() {
        return this.channelContext.voidPromise();
    }

    @Override
    public boolean isTls() {
        return this.tls;
    }

    public boolean supportsFileRegion() {
        return this.supportsFileRegion;
    }

    @Override
    public HttpVersion getProtocol() {
        return HttpVersion.HTTP_1_1;
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this.channelContext.channel().localAddress();
    }

    @Override
    public Optional<Certificate[]> getLocalCertificates() {
        return Optional.ofNullable((SslHandler)this.channelContext.pipeline().get(SslHandler.class)).map(handler -> handler.engine().getSession().getLocalCertificates()).filter(certificates -> ((Certificate[])certificates).length > 0);
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this.channelContext.channel().remoteAddress();
    }

    @Override
    public Optional<Certificate[]> getRemoteCertificates() {
        return Optional.ofNullable((SslHandler)this.channelContext.pipeline().get(SslHandler.class)).map(handler -> {
            try {
                return handler.engine().getSession().getPeerCertificates();
            }
            catch (SSLPeerUnverifiedException e) {
                return null;
            }
        }).filter(certificates -> ((Certificate[])certificates).length > 0);
    }

    @Override
    public synchronized Mono<Void> shutdown() {
        if (this.shutdownSink == null) {
            this.shutdownSink = Sinks.one();
            this.shutdown = this.shutdownSink.asMono().doOnSubscribe(ign -> {
                if (this.gracefulShutdownTimeout != null) {
                    this.gracefulShutdownTimeout.cancel(false);
                    this.gracefulShutdownTimeout = null;
                    this.closing = false;
                }
                if (!this.closing) {
                    this.closing = true;
                    ChannelPromise closePromise = this.channelContext.newPromise().addListener(future -> {
                        this.closed = true;
                        if (future.isSuccess()) {
                            this.shutdownSink.tryEmitEmpty();
                            if (this.gracefulShutdownSink != null) {
                                this.gracefulShutdownSink.tryEmitEmpty();
                            }
                        } else {
                            this.shutdownSink.tryEmitError(future.cause());
                            if (this.gracefulShutdownSink != null) {
                                this.gracefulShutdownSink.tryEmitError(future.cause());
                            }
                        }
                    });
                    this.close(this.channelContext, closePromise);
                }
            }).subscribeOn(Schedulers.fromExecutor((Executor)this.channelContext.executor()));
        }
        return this.shutdown;
    }

    @Override
    public synchronized Mono<Void> shutdownGracefully() {
        if (this.gracefulShutdownSink == null) {
            this.gracefulShutdownSink = Sinks.one();
            this.gracefulShutdown = this.gracefulShutdownSink.asMono().doOnSubscribe(ign -> {
                if (!this.closing) {
                    this.closing = true;
                    this.gracefulShutdownClosePromise = this.channelContext.newPromise().addListener(future -> {
                        this.closed = true;
                        if (future.isSuccess()) {
                            this.gracefulShutdownSink.tryEmitEmpty();
                        } else {
                            this.gracefulShutdownSink.tryEmitError(future.cause());
                        }
                    });
                    if (this.respondingExchange == null) {
                        this.close(this.channelContext, this.gracefulShutdownClosePromise);
                    } else {
                        this.gracefulShutdownTimeout = this.channelContext.executor().schedule(() -> this.close(this.channelContext, this.gracefulShutdownClosePromise), this.configuration.graceful_shutdown_timeout(), TimeUnit.MILLISECONDS);
                    }
                }
            }).subscribeOn(Schedulers.fromExecutor((Executor)this.channelContext.executor()));
        }
        return this.gracefulShutdown;
    }

    private void tryShutdown() {
        if (this.gracefulShutdownTimeout != null && this.respondingExchange == null) {
            this.gracefulShutdownTimeout.cancel(false);
            this.close(this.channelContext, this.gracefulShutdownClosePromise);
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) {
        if (this.channelContext.channel().isActive()) {
            ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener(future -> ctx.close(promise));
        } else {
            ctx.close(promise);
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.channelContext = ctx;
        super.handlerAdded(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.tls = ctx.pipeline().get(SslHandler.class) != null;
        this.supportsFileRegion = !this.tls && ctx.pipeline().get(HttpContentCompressor.class) == null;
        super.channelActive(ctx);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        try {
            super.userEventTriggered(ctx, evt);
        }
        finally {
            if (evt instanceof IdleStateEvent) {
                this.exceptionCaught(ctx, new HttpServerException("Idle timeout: " + String.valueOf(((IdleStateEvent)evt).state())));
            }
        }
    }

    private void dispose(Throwable throwable) {
        AbstractHttp1xExchange current = this.respondingExchange;
        while (current != null) {
            Http1xExchange next = current.next;
            current.next = null;
            current.dispose(throwable);
            current = next;
        }
        this.respondingExchange = null;
        this.requestingExchange = null;
    }

    private void disposeAndShutdown(Throwable throwable) {
        this.dispose(throwable);
        this.shutdown().subscribe();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.dispose(new HttpServerException("Connection was closed"));
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof WebSocketHandshakeException || cause instanceof CorruptedWebSocketFrameException) {
            super.exceptionCaught(ctx, cause);
        } else {
            this.disposeAndShutdown(cause);
            LOGGER.error("Connection error", cause);
        }
    }

    public void decoderError(Throwable cause) {
        if (this.requestingExchange == null) {
            this.disposeAndShutdown(cause);
            LOGGER.warn("Invalid object received", cause);
        } else if (this.requestingExchange == this.respondingExchange.unwrap()) {
            if (!((Http1xResponseHeaders)((Http1xResponse)this.respondingExchange.response()).headers()).isWritten()) {
                HttpResponseStatus status = cause instanceof TooLongHttpLineException ? HttpResponseStatus.REQUEST_URI_TOO_LONG : (cause instanceof TooLongHttpHeaderException ? HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE : HttpResponseStatus.BAD_REQUEST);
                this.channelContext.write((Object)new DefaultFullHttpResponse(this.respondingExchange.version, status));
            }
            this.disposeAndShutdown(cause);
            LOGGER.warn("Invalid object received", cause);
        } else {
            this.decoderError = cause;
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (this.closing || this.decoderError != null) {
            if (msg instanceof ReferenceCounted) {
                ((ReferenceCounted)msg).release();
            }
            return;
        }
        if (msg == LastHttpContent.EMPTY_LAST_CONTENT) {
            if (this.requestingExchange != null && this.requestingExchange.request().getBody() != null) {
                ((Http1xRequestBody)this.requestingExchange.request().getBody()).getDataSink().tryEmitComplete();
            }
        } else if (msg instanceof DefaultHttpRequest) {
            this.read = true;
            HttpRequest httpRequest = (HttpRequest)msg;
            Http1xExchange exchange = new Http1xExchange(this.configuration, this.controller, this.headerService, this.parameterConverter, this.urlEncodedBodyDecoder, this.multipartBodyDecoder, this.headersValidator, this, httpRequest);
            if (msg instanceof LastHttpContent) {
                exchange.request().body().ifPresent(body -> body.getDataSink().tryEmitComplete());
            }
            if (this.requestingExchange == null) {
                this.requestingExchange = exchange;
                this.respondingExchange = this.requestingExchange;
                if (httpRequest.decoderResult().isFailure()) {
                    this.decoderError(httpRequest.decoderResult().cause());
                    return;
                }
                this.respondingExchange.start();
            } else {
                this.requestingExchange = this.requestingExchange.next = exchange;
                if (httpRequest.decoderResult().isFailure()) {
                    this.decoderError(httpRequest.decoderResult().cause());
                }
            }
        } else if (msg instanceof DefaultHttpContent || msg instanceof HttpContent) {
            this.read = true;
            HttpContent content = (HttpContent)msg;
            if (content.decoderResult().isFailure()) {
                content.release();
                this.decoderError(content.decoderResult().cause());
                return;
            }
            if (this.requestingExchange != null) {
                Http1xRequestBody body2 = (Http1xRequestBody)this.requestingExchange.request().getBody();
                if (body2 != null) {
                    if (body2.getDataSink().tryEmitNext((Object)content.content()) != Sinks.EmitResult.OK) {
                        content.release();
                    }
                    if (content instanceof LastHttpContent) {
                        body2.getDataSink().tryEmitComplete();
                    }
                } else {
                    content.release();
                }
            } else {
                content.release();
            }
        } else {
            super.channelRead(ctx, msg);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.read) {
            this.read = false;
            if (this.flush) {
                ctx.flush();
                this.flush = false;
            }
        }
        super.channelReadComplete(ctx);
    }

    public void writeHttpObject(HttpObject object) {
        this.writeHttpObject(object, this.channelContext.voidPromise());
    }

    public void writeHttpObject(HttpObject object, ChannelPromise promise) {
        if (this.channelContext.executor().inEventLoop()) {
            if (this.read) {
                this.flush = true;
                this.channelContext.write((Object)object, promise);
            } else {
                this.channelContext.writeAndFlush((Object)object, promise);
            }
        } else {
            this.channelContext.executor().execute(() -> this.writeHttpObject(object, promise));
        }
    }

    public void writeFileRegion(FileRegion fileRegion) {
        this.writeFileRegion(fileRegion, this.channelContext.voidPromise());
    }

    public void writeFileRegion(FileRegion fileRegion, ChannelPromise promise) {
        if (this.channelContext.executor().inEventLoop()) {
            if (this.read) {
                this.flush = true;
                this.channelContext.write((Object)fileRegion, promise);
            } else {
                this.channelContext.writeAndFlush((Object)fileRegion, promise);
            }
        } else {
            this.channelContext.executor().execute(() -> this.writeFileRegion(fileRegion, promise));
        }
    }

    public Mono<GenericWebSocketExchange> writeWebSocketHandshake(String[] subProtocols) {
        return Mono.defer(() -> {
            WebSocketServerProtocolConfig.Builder webSocketConfigBuilder = WebSocketServerProtocolConfig.newBuilder().websocketPath(((Http1xRequest)this.respondingExchange.request()).getPath()).subprotocols(subProtocols != null && subProtocols.length > 0 ? Arrays.stream(subProtocols).collect(Collectors.joining(",")) : null).checkStartsWith(false).handleCloseFrames(false).dropPongFrames(true).expectMaskedFrames(true).closeOnProtocolViolation(false).allowMaskMismatch(this.configuration.ws_allow_mask_mismatch()).forceCloseTimeoutMillis(this.configuration.ws_close_timeout()).maxFramePayloadLength(this.configuration.ws_max_frame_size().intValue()).allowExtensions(this.configuration.ws_frame_compression_enabled() || this.configuration.ws_message_compression_enabled());
            if (this.configuration.ws_handshake_timeout() > 0L) {
                webSocketConfigBuilder.handshakeTimeoutMillis(this.configuration.ws_handshake_timeout());
            }
            WebSocketConnection webSocketConnection = new WebSocketConnection(this.configuration, webSocketConfigBuilder.build(), this.respondingExchange, this.webSocketFrameFactory, this.webSocketMessageFactory);
            ChannelPipeline pipeline = this.channelContext.pipeline();
            Map initialChannelHandlers = pipeline.toMap();
            LinkedList<Object> extensionHandshakers = new LinkedList<Object>();
            if (this.configuration.ws_frame_compression_enabled()) {
                extensionHandshakers.add(new DeflateFrameServerExtensionHandshaker(this.configuration.ws_frame_compression_level()));
            }
            if (this.configuration.ws_message_compression_enabled()) {
                extensionHandshakers.add(new PerMessageDeflateServerExtensionHandshaker(this.configuration.ws_message_compression_level(), this.configuration.ws_message_allow_server_window_size(), this.configuration.ws_message_prefered_client_window_size(), this.configuration.ws_message_allow_server_no_context(), this.configuration.ws_message_preferred_client_no_context()));
            }
            if (!extensionHandshakers.isEmpty()) {
                pipeline.addLast(new ChannelHandler[]{new WebSocketServerExtensionHandler((WebSocketServerExtensionHandshaker[])extensionHandshakers.toArray(WebSocketServerExtensionHandshaker[]::new))});
            }
            pipeline.addLast(new ChannelHandler[]{webSocketConnection});
            this.channelContext.fireChannelRead((Object)((Http1xRequest)this.respondingExchange.request()).unwrap());
            return webSocketConnection.getWebSocketExchange().doOnError(t -> {
                Iterator currentHandlerNamesIterator;
                for (String currentHandlerName : pipeline.toMap().keySet()) {
                    if (initialChannelHandlers.containsKey(currentHandlerName)) continue;
                    pipeline.remove(currentHandlerName);
                }
                Map currentChannelHandlers = pipeline.toMap();
                if (currentChannelHandlers.size() != initialChannelHandlers.size() && (currentHandlerNamesIterator = currentChannelHandlers.keySet().iterator()).hasNext()) {
                    String currentHandlerName = (String)currentHandlerNamesIterator.next();
                    for (Map.Entry currentInitialHandler : initialChannelHandlers.entrySet()) {
                        if (!((String)currentInitialHandler.getKey()).equals(currentHandlerName)) {
                            pipeline.addBefore(currentHandlerName, (String)currentInitialHandler.getKey(), (ChannelHandler)currentInitialHandler.getValue());
                            continue;
                        }
                        if (!currentHandlerNamesIterator.hasNext()) break;
                        currentHandlerName = (String)currentHandlerNamesIterator.next();
                    }
                }
            });
        });
    }

    public void onExchangeComplete() {
        if (this.channelContext.executor().inEventLoop()) {
            if (!this.respondingExchange.keepAlive) {
                this.shutdown().subscribe();
            } else {
                this.respondingExchange.dispose(null);
                this.respondingExchange = this.respondingExchange.next;
                if (this.respondingExchange != null) {
                    if (this.respondingExchange.next != null || this.decoderError == null) {
                        this.respondingExchange.start();
                    } else {
                        this.decoderError(this.decoderError);
                    }
                } else {
                    this.requestingExchange = null;
                    this.tryShutdown();
                }
            }
        } else {
            this.channelContext.executor().execute(this::onExchangeComplete);
        }
    }

    public void onExchangeError(Throwable throwable) {
        if (this.channelContext.executor().inEventLoop()) {
            this.respondingExchange.handleError(throwable);
        } else {
            this.channelContext.executor().execute(() -> this.onExchangeError(throwable));
        }
    }
}

