/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.Status;
import io.inverno.mod.http.base.internal.netty.FlatFullHttpResponse;
import io.inverno.mod.http.base.internal.netty.LinkedHttpHeaders;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.HttpServerException;
import io.inverno.mod.http.server.ServerController;
import io.inverno.mod.http.server.internal.AbstractExchange;
import io.inverno.mod.http.server.internal.http1x.Http1xConnection;
import io.inverno.mod.http.server.internal.http1x.Http1xErrorExchange;
import io.inverno.mod.http.server.internal.http1x.Http1xExchange;
import io.inverno.mod.http.server.internal.http1x.Http1xRequest;
import io.inverno.mod.http.server.internal.http1x.Http1xResponse;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseHeaders;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;

abstract class AbstractHttp1xExchange
extends AbstractExchange<Http1xRequest, Http1xResponse, Http1xErrorExchange> {
    protected final Http1xConnection connection;
    protected final HttpVersion version;
    protected final boolean keepAlive;
    Http1xExchange next;
    protected boolean reset;

    public AbstractHttp1xExchange(HttpServerConfiguration configuration, ServerController<ExchangeContext, Exchange<ExchangeContext>, ErrorExchange<ExchangeContext>> controller, Http1xConnection connection, HttpRequest request) {
        super(configuration, controller, request.method() == HttpMethod.HEAD);
        this.connection = connection;
        this.version = request.protocolVersion();
        this.keepAlive = this.version == HttpVersion.HTTP_1_1 && !request.headers().contains((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.CLOSE, true) || this.version == HttpVersion.HTTP_1_0 && request.headers().contains((CharSequence)HttpHeaderNames.CONNECTION, (CharSequence)HttpHeaderValues.KEEP_ALIVE, true);
    }

    protected AbstractHttp1xExchange(Http1xExchange parentExchange) {
        super(parentExchange);
        this.connection = parentExchange.connection;
        this.version = parentExchange.version;
        this.keepAlive = parentExchange.keepAlive;
        this.next = parentExchange.next;
        this.reset = parentExchange.reset;
    }

    abstract Http1xExchange unwrap();

    public final io.inverno.mod.http.base.HttpVersion getProtocol() {
        return this.version == HttpVersion.HTTP_1_0 ? io.inverno.mod.http.base.HttpVersion.HTTP_1_0 : io.inverno.mod.http.base.HttpVersion.HTTP_1_1;
    }

    public final void reset(long code) {
        if (this.connection.executor().inEventLoop()) {
            if (!this.reset) {
                this.reset = true;
                this.dispose(new HttpServerException("Exchange was reset: " + code));
                if (((Http1xResponseHeaders)((Http1xResponse)this.response()).headers()).isWritten()) {
                    this.connection.shutdown().subscribe();
                } else {
                    LinkedHttpHeaders httpHeaders = new LinkedHttpHeaders();
                    if (this.version == HttpVersion.HTTP_1_0) {
                        if (this.keepAlive) {
                            httpHeaders.set((CharSequence)"connection", (Object)"keep-alive");
                        }
                    } else if (!this.keepAlive) {
                        httpHeaders.set((CharSequence)"connection", (Object)"close");
                    }
                    httpHeaders.set((CharSequence)"content-length", (Object)"0");
                    this.connection.writeHttpObject((HttpObject)new FlatFullHttpResponse(this.version, HttpResponseStatus.valueOf((int)Status.CANCELLED_REQUEST.getCode()), (HttpHeaders)httpHeaders, Unpooled.EMPTY_BUFFER, null));
                    this.connection.onExchangeComplete();
                }
            }
        } else {
            this.connection.executor().execute(() -> this.reset(code));
        }
    }
}

