/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.core.annotation.Bean;
import io.inverno.core.annotation.Destroy;
import io.inverno.core.annotation.Init;
import io.inverno.mod.base.net.NetService;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.HttpServerException;
import io.inverno.mod.http.server.internal.HttpConnectionGroup;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.socket.SocketChannel;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class HttpServer {
    private static final Logger LOGGER = LogManager.getLogger(HttpServer.class);
    private final NetService netService;
    private final HttpServerConfiguration configuration;
    private final ChannelInitializer<SocketChannel> channelInitializer;
    private final HttpConnectionGroup connectionGroup;
    private ChannelFuture serverChannelFuture;

    public HttpServer(HttpServerConfiguration configuration, NetService netService, ChannelInitializer<SocketChannel> channelInitializer, HttpConnectionGroup connectionGroup) {
        this.configuration = configuration;
        this.netService = netService;
        this.channelInitializer = channelInitializer;
        this.connectionGroup = connectionGroup;
    }

    @Init
    public void start() throws HttpServerException, InterruptedException {
        String scheme;
        InetSocketAddress serverAddress = new InetSocketAddress(this.configuration.server_host(), this.configuration.server_port());
        ServerBootstrap serverBootstrap = this.configuration.server_event_loop_group_size() != null ? this.netService.createServer((SocketAddress)serverAddress, this.configuration.server_event_loop_group_size().intValue()) : this.netService.createServer((SocketAddress)serverAddress);
        this.serverChannelFuture = serverBootstrap.childHandler(this.channelInitializer).bind((SocketAddress)serverAddress).sync();
        String string = scheme = this.configuration.tls_enabled() ? "https://" : "http://";
        if (!this.serverChannelFuture.isSuccess()) {
            throw new HttpServerException("Can't start Web server on " + scheme + serverAddress.getHostString() + ":" + serverAddress.getPort(), this.serverChannelFuture.cause());
        }
        LOGGER.info("HTTP Server ({}) listening on {}", (Object)this.netService.getTransportType().toString().toLowerCase(), (Object)(scheme + serverAddress.getHostString() + ":" + serverAddress.getPort()));
    }

    @Destroy
    public void stop() throws InterruptedException {
        if (this.configuration.graceful_shutdown()) {
            this.connectionGroup.shutdownGracefully().block();
        } else {
            this.connectionGroup.shutdown().block();
        }
        this.serverChannelFuture.channel().close();
        LOGGER.info("HTTP Server stopped");
    }
}

