/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.OutboundResponseHeaders;
import io.inverno.mod.http.base.OutboundSetCookies;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.header.SetCookie;
import io.inverno.mod.http.base.header.SetCookieParameter;
import io.inverno.mod.http.base.internal.header.GenericSetCookieParameter;
import io.inverno.mod.http.base.internal.header.SetCookieCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;

public class GenericResponseCookies
implements OutboundSetCookies {
    private final HeaderService headerService;
    private final OutboundResponseHeaders responseHeaders;
    private final ObjectConverter<String> parameterConverter;
    private Map<String, List<SetCookieParameter>> pairs;

    public GenericResponseCookies(HeaderService headerService, OutboundResponseHeaders responseHeaders, ObjectConverter<String> parameterConverter) {
        this.headerService = headerService;
        this.responseHeaders = responseHeaders;
        this.parameterConverter = parameterConverter;
    }

    public OutboundSetCookies addCookie(Consumer<SetCookie.Configurator> configurer) {
        if (configurer != null) {
            SetCookieCodec.SetCookie setCookie = new SetCookieCodec.SetCookie();
            configurer.accept((SetCookie.Configurator)setCookie);
            setCookie.setHeaderValue(this.headerService.encodeValue((Header)setCookie));
            this.responseHeaders.add(new Header[]{setCookie});
            if (this.pairs != null) {
                this.pairs.computeIfAbsent(setCookie.getName(), ign -> new ArrayList()).add(new GenericSetCookieParameter((Headers.SetCookie)setCookie, this.parameterConverter));
            }
        }
        return this;
    }

    public boolean contains(String name) {
        return this.getAll().containsKey(name);
    }

    public Set<String> getNames() {
        return this.getAll().keySet();
    }

    public Optional<SetCookieParameter> get(String name) {
        return Optional.ofNullable(this.getAll().get(name)).map(setCookies -> {
            if (!setCookies.isEmpty()) {
                return (SetCookieParameter)setCookies.get(0);
            }
            return null;
        });
    }

    public List<SetCookieParameter> getAll(String name) {
        List<SetCookieParameter> setCookiePairs = this.pairs.get(name);
        return setCookiePairs != null ? setCookiePairs : List.of();
    }

    public Map<String, List<SetCookieParameter>> getAll() {
        if (this.pairs == null) {
            this.pairs = new HashMap<String, List<SetCookieParameter>>();
            for (Headers.SetCookie setCookie : this.responseHeaders.getAllHeader((CharSequence)"set-cookie")) {
                this.pairs.computeIfAbsent(setCookie.getName(), ign -> new ArrayList()).add(new GenericSetCookieParameter(setCookie, this.parameterConverter));
            }
        }
        return this.pairs;
    }
}

