/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.OutboundHeaders;
import io.inverno.mod.http.base.OutboundResponseHeaders;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.Response;
import io.inverno.mod.http.server.internal.AbstractResponseBody;
import io.inverno.mod.http.server.internal.AbstractResponseHeaders;
import io.inverno.mod.http.server.internal.AbstractResponseTrailers;
import java.util.function.Consumer;

public abstract class AbstractResponse<A extends AbstractResponseHeaders<?>, B extends AbstractResponseBody, C extends AbstractResponseTrailers<?>, D extends AbstractResponse<A, B, C, D>>
implements Response {
    protected final HeaderService headerService;
    protected final ObjectConverter<String> parameterConverter;
    protected final boolean head;
    protected final A headers;
    protected int transferedLength;

    public AbstractResponse(HeaderService headerService, ObjectConverter<String> parameterConverter, boolean head, A headers) {
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.head = head;
        this.headers = headers;
    }

    public abstract void send();

    @Override
    public boolean isHeadersWritten() {
        return ((AbstractResponseHeaders)this.headers).isWritten();
    }

    @Override
    public int getTransferedLength() {
        return this.transferedLength;
    }

    public D headers(Consumer<OutboundResponseHeaders> headersConfigurer) throws IllegalStateException {
        if (((AbstractResponseHeaders)this.headers).isWritten()) {
            throw new IllegalStateException("Headers already written");
        }
        if (headersConfigurer != null) {
            headersConfigurer.accept((OutboundResponseHeaders)this.headers);
        }
        return (D)this;
    }

    public A headers() {
        return this.headers;
    }

    public D trailers(Consumer<OutboundHeaders<?>> trailersConfigurer) {
        if (((AbstractResponseTrailers)this.trailers()).isWritten()) {
            throw new IllegalStateException("Trailers already written");
        }
        if (trailersConfigurer != null) {
            trailersConfigurer.accept((OutboundHeaders<?>)this.trailers());
        }
        return (D)this;
    }

    public abstract C trailers();

    public abstract D sendContinue();

    public abstract B body();
}

