/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.mod.base.Charsets;
import io.inverno.mod.http.base.InboundData;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.server.HttpServerException;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.RequestBody;
import io.inverno.mod.http.server.internal.AbstractRequestHeaders;
import io.inverno.mod.http.server.internal.StacklessHttpServerException;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.netty.buffer.ByteBuf;
import io.netty.util.ReferenceCounted;
import java.util.Map;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;

public abstract class AbstractRequestBody<A extends AbstractRequestHeaders>
implements RequestBody {
    private static final HttpServerException REQUEST_DISPOSED_ERROR = new StacklessHttpServerException("Request was disposed");
    private final MultipartDecoder<Parameter> urlEncodedBodyDecoder;
    private final MultipartDecoder<Part> multipartBodyDecoder;
    private final A headers;
    private final Sinks.Many<ByteBuf> dataSink;
    private Flux<ByteBuf> data;
    private boolean subscribed;
    protected InboundData<ByteBuf> rawData;
    protected InboundData<CharSequence> stringData;
    protected RequestBody.UrlEncoded urlEncodedData;
    protected RequestBody.Multipart<Part> multipartData;
    private Throwable cancelCause;

    public AbstractRequestBody(MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder, A headers) {
        this.urlEncodedBodyDecoder = urlEncodedBodyDecoder;
        this.multipartBodyDecoder = multipartBodyDecoder;
        this.headers = headers;
        this.dataSink = Sinks.many().unicast().onBackpressureBuffer();
        this.data = Flux.defer(() -> {
            if (this.cancelCause != null) {
                return Mono.error((Throwable)this.cancelCause);
            }
            return this.dataSink.asFlux().doOnSubscribe(ign -> {
                this.subscribed = true;
            }).doOnDiscard(ByteBuf.class, ReferenceCounted::release);
        });
    }

    public final Sinks.Many<ByteBuf> getDataSink() {
        return this.dataSink;
    }

    public final void dispose(Throwable cause) {
        if (this.cancelCause == null) {
            if (cause != null) {
                this.cancelCause = cause;
                this.dataSink.tryEmitError(cause);
            } else {
                this.cancelCause = REQUEST_DISPOSED_ERROR;
                this.dataSink.tryEmitComplete();
            }
            if (!this.subscribed) {
                try {
                    this.data.subscribe(ReferenceCounted::release, ex -> {});
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    @Override
    public final RequestBody transform(Function<Publisher<ByteBuf>, Publisher<ByteBuf>> transformer) throws IllegalStateException {
        if (this.subscribed) {
            throw new IllegalStateException("Request data already consumed");
        }
        this.data = Flux.from(transformer.apply((Publisher<ByteBuf>)this.data));
        return this;
    }

    @Override
    public InboundData<ByteBuf> raw() throws IllegalStateException {
        if (this.rawData == null) {
            this.rawData = new RawInboundData();
        }
        return this.rawData;
    }

    @Override
    public InboundData<CharSequence> string() throws IllegalStateException {
        if (this.stringData == null) {
            this.stringData = new StringInboundData();
        }
        return this.stringData;
    }

    @Override
    public RequestBody.UrlEncoded urlEncoded() throws IllegalStateException {
        if (this.urlEncodedData == null) {
            this.urlEncodedData = new UrlEncodedInboundData(this, (Publisher<Parameter>)this.urlEncodedBodyDecoder.decode(this.data, this.headers.getContentTypeHeader()));
        }
        return this.urlEncodedData;
    }

    @Override
    public RequestBody.Multipart<? extends Part> multipart() throws IllegalStateException {
        if (this.multipartData == null) {
            this.multipartData = new MultipartInboundData(this, (Publisher<Part>)this.multipartBodyDecoder.decode(this.data, this.headers.getContentTypeHeader()));
        }
        return this.multipartData;
    }

    protected class RawInboundData
    implements InboundData<ByteBuf> {
        protected RawInboundData() {
        }

        public Publisher<ByteBuf> stream() {
            return AbstractRequestBody.this.data;
        }
    }

    protected class StringInboundData
    implements InboundData<CharSequence> {
        protected StringInboundData() {
        }

        public Publisher<CharSequence> stream() {
            return AbstractRequestBody.this.data.map(buf -> {
                try {
                    String string = buf.toString(Charsets.DEFAULT);
                    return string;
                }
                finally {
                    buf.release();
                }
            });
        }
    }

    protected class UrlEncodedInboundData
    implements RequestBody.UrlEncoded {
        private final Publisher<Parameter> parameters;
        private Mono<Map<String, Parameter>> parametersMap;

        public UrlEncodedInboundData(AbstractRequestBody this$0, Publisher<Parameter> parameters) {
            this.parameters = Flux.from(parameters).cache();
        }

        public Publisher<Parameter> stream() {
            return this.parameters;
        }

        @Override
        public Mono<Map<String, Parameter>> collectMap() {
            if (this.parametersMap == null) {
                this.parametersMap = Flux.from(this.parameters).collectMap(Parameter::getName).cache();
            }
            return this.parametersMap;
        }
    }

    protected class MultipartInboundData
    implements RequestBody.Multipart<Part> {
        private final Publisher<Part> parts;

        public MultipartInboundData(AbstractRequestBody this$0, Publisher<Part> parts) {
            this.parts = parts;
        }

        public Publisher<Part> stream() {
            return this.parts;
        }
    }
}

