/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.base.net.URIBuilder;
import io.inverno.mod.base.net.URIs;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.QueryParameters;
import io.inverno.mod.http.base.internal.GenericQueryParameters;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.Request;
import io.inverno.mod.http.server.internal.AbstractRequestBody;
import io.inverno.mod.http.server.internal.AbstractRequestHeaders;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import java.util.Optional;

public abstract class AbstractRequest<A extends AbstractRequestHeaders, B extends AbstractRequestBody>
implements Request {
    protected final ObjectConverter<String> parameterConverter;
    protected final MultipartDecoder<Parameter> urlEncodedBodyDecoder;
    protected final MultipartDecoder<Part> multipartBodyDecoder;
    protected final A headers;
    private URIBuilder pathBuilder;
    private String pathAbsolute;
    private String queryString;
    private GenericQueryParameters queryParameters;
    protected B body;

    public AbstractRequest(ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder, A headers) {
        this.parameterConverter = parameterConverter;
        this.urlEncodedBodyDecoder = urlEncodedBodyDecoder;
        this.multipartBodyDecoder = multipartBodyDecoder;
        this.headers = headers;
    }

    public final void dispose(Throwable cause) {
        if (this.body != null) {
            ((AbstractRequestBody)this.body).dispose(cause);
        }
    }

    private URIBuilder getPrimaryPathBuilder() {
        if (this.pathBuilder == null) {
            this.pathBuilder = URIs.uri((String)this.getPath(), (boolean)false, (URIs.Option[])new URIs.Option[]{URIs.Option.NORMALIZED});
        }
        return this.pathBuilder;
    }

    public String getPathAbsolute() {
        if (this.pathAbsolute == null) {
            this.pathAbsolute = this.getPrimaryPathBuilder().buildRawPath();
        }
        return this.pathAbsolute;
    }

    public URIBuilder getPathBuilder() {
        return this.getPrimaryPathBuilder().clone();
    }

    public String getQuery() {
        if (this.queryString == null) {
            this.queryString = this.getPrimaryPathBuilder().buildRawQuery();
        }
        return this.queryString;
    }

    public QueryParameters queryParameters() {
        if (this.queryParameters == null) {
            this.queryParameters = new GenericQueryParameters(this.getPrimaryPathBuilder().getQueryParameters(new Object[0]), this.parameterConverter);
        }
        return this.queryParameters;
    }

    public A headers() {
        return this.headers;
    }

    public abstract Optional<B> body();

    public B getBody() {
        return this.body;
    }
}

