/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.HttpServerException;
import io.inverno.mod.http.server.Request;
import io.inverno.mod.http.server.Response;
import io.inverno.mod.http.server.ServerController;
import io.inverno.mod.http.server.internal.StacklessHttpServerException;
import java.util.Optional;

public abstract class AbstractExchange<A extends Request, B extends Response, C extends ErrorExchange<ExchangeContext>>
implements Exchange<ExchangeContext> {
    private static final HttpServerException EXCHANGE_DISPOSED_ERROR = new StacklessHttpServerException("Exchange was disposed");
    protected final HttpServerConfiguration configuration;
    protected final ServerController<ExchangeContext, Exchange<ExchangeContext>, ErrorExchange<ExchangeContext>> controller;
    protected final boolean head;
    private Throwable cancelCause;

    public AbstractExchange(HttpServerConfiguration configuration, ServerController<ExchangeContext, Exchange<ExchangeContext>, ErrorExchange<ExchangeContext>> controller, boolean head) {
        this.configuration = configuration;
        this.controller = controller;
        this.head = head;
    }

    protected AbstractExchange(AbstractExchange<A, B, C> parentExchange) {
        this.configuration = parentExchange.configuration;
        this.controller = parentExchange.controller;
        this.head = parentExchange.head;
    }

    public abstract void start();

    public abstract void handleError(Throwable var1);

    public abstract C createErrorExchange(Throwable var1);

    public final void dispose(Throwable cause) {
        if (this.cancelCause == null) {
            this.cancelCause = cause != null ? cause : EXCHANGE_DISPOSED_ERROR;
            this.doDispose(cause);
        }
    }

    protected abstract void doDispose(Throwable var1);

    public abstract A request();

    public abstract B response();

    public Optional<Throwable> getCancelCause() {
        return Optional.ofNullable(this.cancelCause);
    }
}

