/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server;

import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.HttpException;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.ExchangeHandler;
import io.inverno.mod.http.server.ReactiveExchangeHandler;
import io.inverno.mod.http.server.ReactiveServerController;
import io.inverno.mod.http.server.internal.GenericErrorExchangeHandler;
import java.util.Objects;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

@FunctionalInterface
public interface ServerController<A extends ExchangeContext, B extends Exchange<A>, C extends ErrorExchange<A>>
extends ReactiveServerController<A, B, C> {
    @Override
    default public Mono<Void> defer(B exchange) throws HttpException {
        return Mono.fromRunnable(() -> this.handle((C)exchange));
    }

    public void handle(B var1) throws HttpException;

    @Override
    default public Mono<Void> defer(C errorExchange) throws HttpException {
        return Mono.fromRunnable(() -> this.handle(errorExchange));
    }

    default public void handle(C errorExchange) throws HttpException {
        GenericErrorExchangeHandler.INSTANCE.handle((ErrorExchange<ExchangeContext>)errorExchange);
    }

    default public A createContext() {
        return null;
    }

    public static <U extends ExchangeContext, V extends Exchange<U>, W extends ErrorExchange<U>> ServerController<U, V, W> from(final ReactiveExchangeHandler<U, V> handler) {
        Objects.requireNonNull(handler);
        return new ServerController<U, V, W>(){

            @Override
            public Mono<Void> defer(V exchange) throws HttpException {
                return handler.defer(exchange);
            }

            @Override
            public void handle(V exchange) throws HttpException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Mono<Void> defer(W errorExchange) throws HttpException {
                return GenericErrorExchangeHandler.INSTANCE.defer(errorExchange);
            }

            @Override
            public void handle(W errorExchange) throws HttpException {
                GenericErrorExchangeHandler.INSTANCE.handle((ErrorExchange<ExchangeContext>)errorExchange);
            }
        };
    }

    public static <U extends ExchangeContext, V extends Exchange<U>, W extends ErrorExchange<U>> ServerController<U, V, W> from(final ExchangeHandler<U, V> handler) {
        Objects.requireNonNull(handler);
        return new ServerController<U, V, W>(){

            @Override
            public Mono<Void> defer(V exchange) throws HttpException {
                return handler.defer(exchange);
            }

            @Override
            public void handle(V exchange) throws HttpException {
                handler.handle(exchange);
            }

            @Override
            public Mono<Void> defer(W errorExchange) throws HttpException {
                return GenericErrorExchangeHandler.INSTANCE.defer(errorExchange);
            }

            @Override
            public void handle(W errorExchange) throws HttpException {
                GenericErrorExchangeHandler.INSTANCE.handle((ErrorExchange<ExchangeContext>)errorExchange);
            }
        };
    }

    public static <U extends ExchangeContext, V extends Exchange<U>, W extends ErrorExchange<U>> ServerController<U, V, W> from(final ReactiveExchangeHandler<U, V> handler, final ReactiveExchangeHandler<U, W> errorHandler) {
        Objects.requireNonNull(handler);
        Objects.requireNonNull(errorHandler);
        return new ServerController<U, V, W>(){

            @Override
            public Mono<Void> defer(V exchange) throws HttpException {
                return handler.defer(exchange);
            }

            @Override
            public void handle(V exchange) throws HttpException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Mono<Void> defer(W errorExchange) throws HttpException {
                return errorHandler.defer(errorExchange);
            }

            @Override
            public void handle(W errorExchange) throws HttpException {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static <U extends ExchangeContext, V extends Exchange<U>, W extends ErrorExchange<U>> ServerController<U, V, W> from(final ExchangeHandler<U, V> handler, final ExchangeHandler<U, W> errorHandler) {
        Objects.requireNonNull(handler);
        Objects.requireNonNull(errorHandler);
        return new ServerController<U, V, W>(){

            @Override
            public Mono<Void> defer(V exchange) throws HttpException {
                return handler.defer(exchange);
            }

            @Override
            public void handle(V exchange) throws HttpException {
                handler.handle(exchange);
            }

            @Override
            public Mono<Void> defer(W errorExchange) throws HttpException {
                return errorHandler.defer(errorExchange);
            }

            @Override
            public void handle(W errorExchange) throws HttpException {
                errorHandler.handle(errorExchange);
            }
        };
    }

    public static <U extends ExchangeContext, V extends Exchange<U>, W extends ErrorExchange<U>> ServerController<U, V, W> from(final ReactiveExchangeHandler<U, V> handler, final ReactiveExchangeHandler<U, W> errorHandler, final Supplier<U> contextSupplier) {
        Objects.requireNonNull(handler);
        Objects.requireNonNull(errorHandler);
        Objects.requireNonNull(contextSupplier);
        return new ServerController<U, V, W>(){

            @Override
            public Mono<Void> defer(V exchange) throws HttpException {
                return handler.defer(exchange);
            }

            @Override
            public void handle(V exchange) throws HttpException {
                throw new UnsupportedOperationException();
            }

            @Override
            public Mono<Void> defer(W errorExchange) throws HttpException {
                return errorHandler.defer(errorExchange);
            }

            @Override
            public void handle(W errorExchange) throws HttpException {
                throw new UnsupportedOperationException();
            }

            @Override
            public U createContext() {
                return (ExchangeContext)contextSupplier.get();
            }
        };
    }

    public static <U extends ExchangeContext, V extends Exchange<U>, W extends ErrorExchange<U>> ServerController<U, V, W> from(final ExchangeHandler<U, V> handler, final ExchangeHandler<U, W> errorHandler, final Supplier<U> contextSupplier) {
        Objects.requireNonNull(handler);
        Objects.requireNonNull(errorHandler);
        Objects.requireNonNull(contextSupplier);
        return new ServerController<U, V, W>(){

            @Override
            public Mono<Void> defer(V exchange) throws HttpException {
                return handler.defer(exchange);
            }

            @Override
            public void handle(V exchange) throws HttpException {
                handler.handle(exchange);
            }

            @Override
            public Mono<Void> defer(W errorExchange) throws HttpException {
                return errorHandler.defer(errorExchange);
            }

            @Override
            public void handle(W errorExchange) throws HttpException {
                errorHandler.handle(errorExchange);
            }

            @Override
            public U createContext() {
                return (ExchangeContext)contextSupplier.get();
            }
        };
    }
}

