/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server;

import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.ExchangeInterceptor;
import io.inverno.mod.http.server.Request;
import io.inverno.mod.http.server.Response;
import java.net.InetSocketAddress;
import org.apache.commons.text.StringEscapeUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MultiformatMessage;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;

public class HttpAccessLogsInterceptor<A extends ExchangeContext, B extends Exchange<A>>
implements ExchangeInterceptor<A, B> {
    private static final Logger LOGGER = LogManager.getLogger(Exchange.class);

    @Override
    public Mono<? extends B> intercept(B exchange) {
        ((Response)exchange.response()).body().transform(data -> {
            if (data instanceof Mono) {
                return Mono.from((Publisher)data).doFinally(sig -> {
                    if (sig == SignalType.ON_COMPLETE) {
                        LOGGER.info((Message)new AccessLogMessage(this, exchange));
                    }
                });
            }
            return Flux.from((Publisher)data).doFinally(sig -> {
                if (sig == SignalType.ON_COMPLETE) {
                    LOGGER.info((Message)new AccessLogMessage(this, exchange));
                }
            });
        });
        return Mono.just(exchange);
    }

    private static class AccessLogMessage
    implements MultiformatMessage {
        private static final long serialVersionUID = 1L;
        private static final String JSON_FORMAT = "JSON";
        private final String remoteAddress;
        private final String request;
        private final int statusCode;
        private final int transferedLength;
        private final String referer;
        private final String userAgent;
        final /* synthetic */ HttpAccessLogsInterceptor this$0;

        public AccessLogMessage(B exchange) {
            this.this$0 = var1_1;
            this.remoteAddress = ((InetSocketAddress)((Request)exchange.request()).getRemoteAddress()).getAddress().getHostAddress();
            this.request = ((Request)exchange.request()).getMethod().name() + " " + ((Request)exchange.request()).getPath();
            this.statusCode = ((Response)exchange.response()).headers().getStatusCode();
            this.transferedLength = ((Response)exchange.response()).getTransferedLength();
            this.referer = ((Request)exchange.request()).headers().get((CharSequence)"referer").orElse("");
            this.userAgent = ((Request)exchange.request()).headers().get((CharSequence)"user-agent").orElse("");
        }

        public String getFormat() {
            return "";
        }

        public Object[] getParameters() {
            return new Object[]{this.remoteAddress, this.request, this.statusCode, this.transferedLength, this.referer, this.userAgent};
        }

        public Throwable getThrowable() {
            return null;
        }

        public String getFormattedMessage() {
            return this.asString();
        }

        public String getFormattedMessage(String[] formats) {
            for (String format : formats) {
                if (!format.equalsIgnoreCase(JSON_FORMAT)) continue;
                return this.asJson();
            }
            return this.asString();
        }

        public String[] getFormats() {
            return new String[]{JSON_FORMAT};
        }

        private String asString() {
            StringBuilder message = new StringBuilder();
            message.append(this.remoteAddress).append(" ");
            message.append("\"").append(this.request).append("\" ");
            message.append(this.statusCode).append(" ");
            message.append(this.transferedLength).append(" ");
            message.append("\"").append(this.referer).append("\" ");
            message.append("\"").append(this.userAgent).append("\" ");
            return message.toString();
        }

        private String asJson() {
            StringBuilder message = new StringBuilder();
            message.append("{");
            message.append("\"remoteAddress\":\"").append(this.remoteAddress).append("\",");
            message.append("\"request\":\"").append(StringEscapeUtils.escapeJson((String)this.request)).append("\",");
            message.append("\"status\":").append(this.statusCode).append(",");
            message.append("\"bytes\":").append(this.transferedLength).append(",");
            message.append("\"referer\":\"").append(StringEscapeUtils.escapeJson((String)this.referer)).append("\",");
            message.append("\"userAgent\":\"").append(StringEscapeUtils.escapeJson((String)this.userAgent)).append("\"");
            message.append("}");
            return message.toString();
        }
    }
}

