/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server;

import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.HttpVersion;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.Request;
import io.inverno.mod.http.server.Response;
import io.inverno.mod.http.server.ws.WebSocket;
import io.inverno.mod.http.server.ws.WebSocketExchange;
import java.util.Optional;
import java.util.function.Function;

public interface ErrorExchange<A extends ExchangeContext>
extends Exchange<A> {
    public Throwable getError();

    @Override
    default public Optional<? extends WebSocket<A, ? extends WebSocketExchange<A>>> webSocket(String ... subProtocols) {
        return Optional.empty();
    }

    default public ErrorExchange<A> mapError(final Function<? super Throwable, ? extends Throwable> errorMapper) {
        final ErrorExchange thisExchange = this;
        return new ErrorExchange<A>(){

            public HttpVersion getProtocol() {
                return thisExchange.getProtocol();
            }

            public Request request() {
                return (Request)thisExchange.request();
            }

            public Response response() {
                return (Response)thisExchange.response();
            }

            public A context() {
                return thisExchange.context();
            }

            @Override
            public Throwable getError() {
                return (Throwable)errorMapper.apply(thisExchange.getError());
            }

            public void reset(long code) {
                thisExchange.reset(code);
            }

            public Optional<Throwable> getCancelCause() {
                return thisExchange.getCancelCause();
            }
        };
    }
}

