/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.Status;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.internal.GenericParameter;
import io.inverno.mod.http.server.ResponseHeaders;
import io.inverno.mod.http.server.internal.AbstractResponseHeaders;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class Http2ResponseHeaders
implements AbstractResponseHeaders {
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;
    private final Http2Headers underlyingHeaders;
    private boolean written;

    public Http2ResponseHeaders(HeaderService headerService, ObjectConverter<String> parameterConverter) {
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.underlyingHeaders = new DefaultHttp2Headers();
        this.underlyingHeaders.set((Object)Http2Headers.PseudoHeaderName.STATUS.value(), (Object)"200");
    }

    Http2Headers getUnderlyingHeaders() {
        return this.underlyingHeaders;
    }

    @Override
    public Http2ResponseHeaders status(Status status) {
        return this.status(status.getCode());
    }

    @Override
    public Http2ResponseHeaders status(int status) {
        this.underlyingHeaders.setInt((Object)Http2Headers.PseudoHeaderName.STATUS.value(), status);
        return this;
    }

    @Override
    public Http2ResponseHeaders contentType(String contentType) {
        this.underlyingHeaders.set((Object)"content-type", (Object)contentType);
        return this;
    }

    @Override
    public Http2ResponseHeaders contentLength(long contentLength) {
        this.underlyingHeaders.setLong((Object)"content-length", contentLength);
        return this;
    }

    @Override
    public Http2ResponseHeaders add(CharSequence name, CharSequence value) {
        this.underlyingHeaders.add((Object)name, (Object)value);
        return this;
    }

    @Override
    public Http2ResponseHeaders add(Header ... headers) {
        for (Header header : headers) {
            this.underlyingHeaders.add((Object)header.getHeaderName(), (Object)header.getHeaderValue());
        }
        return this;
    }

    @Override
    public ResponseHeaders set(CharSequence name, CharSequence value) {
        this.underlyingHeaders.set((Object)name, (Object)value);
        return this;
    }

    @Override
    public ResponseHeaders set(Header ... headers) {
        for (Header header : headers) {
            this.underlyingHeaders.set((Object)header.getHeaderName(), (Object)header.getHeaderValue());
        }
        return this;
    }

    @Override
    public ResponseHeaders remove(CharSequence ... names) {
        for (CharSequence name : names) {
            this.underlyingHeaders.remove((Object)name);
        }
        return this;
    }

    @Override
    public boolean isWritten() {
        return this.written;
    }

    @Override
    public void setWritten(boolean written) {
        this.written = written;
    }

    @Override
    public Optional<String> getContentType() {
        return Optional.ofNullable(((CharSequence)this.underlyingHeaders.get((Object)"content-type")).toString());
    }

    @Override
    public Optional<Headers.ContentType> getContentTypeHeader() {
        return this.getHeader("content-type");
    }

    @Override
    public CharSequence getContentTypeCharSequence() {
        return (CharSequence)this.underlyingHeaders.get((Object)"content-type");
    }

    @Override
    public Optional<String> get(CharSequence name) {
        return Optional.ofNullable((CharSequence)this.underlyingHeaders.get((Object)name)).map(Object::toString);
    }

    @Override
    public CharSequence getCharSequence(CharSequence name) {
        return (CharSequence)this.underlyingHeaders.get((Object)name);
    }

    @Override
    public List<String> getAll(CharSequence name) {
        return this.underlyingHeaders.getAll((Object)name).stream().map(CharSequence::toString).collect(Collectors.toList());
    }

    @Override
    public List<CharSequence> getAllCharSequence(CharSequence name) {
        return this.underlyingHeaders.getAll((Object)name);
    }

    @Override
    public List<Map.Entry<String, String>> getAll() {
        LinkedList<Map.Entry<String, String>> result = new LinkedList<Map.Entry<String, String>>();
        this.underlyingHeaders.forEach(e -> result.add(Map.entry(((CharSequence)e.getKey()).toString(), ((CharSequence)e.getValue()).toString())));
        return result;
    }

    @Override
    public List<Map.Entry<CharSequence, CharSequence>> getAllCharSequence() {
        LinkedList<Map.Entry<CharSequence, CharSequence>> result = new LinkedList<Map.Entry<CharSequence, CharSequence>>();
        this.underlyingHeaders.forEach(e -> result.add(Map.entry((CharSequence)e.getKey(), (CharSequence)e.getValue())));
        return result;
    }

    @Override
    public <T extends Header> Optional<T> getHeader(CharSequence name) {
        return this.get(name).map(value -> this.headerService.decode(name.toString(), value));
    }

    @Override
    public <T extends Header> List<T> getAllHeader(CharSequence name) {
        return this.underlyingHeaders.getAll((Object)name).stream().map(value -> this.headerService.decode(name.toString(), value.toString())).collect(Collectors.toList());
    }

    @Override
    public List<Header> getAllHeader() {
        LinkedList<Header> result = new LinkedList<Header>();
        this.underlyingHeaders.forEach(e -> result.add(this.headerService.decode(((CharSequence)e.getKey()).toString(), ((CharSequence)e.getValue()).toString())));
        return result;
    }

    @Override
    public Optional<Parameter> getParameter(CharSequence name) {
        return this.get(name).map(value -> new GenericParameter(name.toString(), value, this.parameterConverter));
    }

    @Override
    public List<Parameter> getAllParameter(CharSequence name) {
        return this.underlyingHeaders.getAll((Object)name).stream().map(value -> new GenericParameter(name.toString(), value.toString(), this.parameterConverter)).collect(Collectors.toList());
    }

    @Override
    public List<Parameter> getAllParameter() {
        LinkedList<Parameter> result = new LinkedList<Parameter>();
        this.underlyingHeaders.forEach(e -> result.add((Parameter)new GenericParameter(((CharSequence)e.getKey()).toString(), ((CharSequence)e.getValue()).toString(), this.parameterConverter)));
        return result;
    }

    @Override
    public Set<String> getNames() {
        return this.underlyingHeaders.names().stream().map(CharSequence::toString).collect(Collectors.toSet());
    }

    @Override
    public Long getContentLength() {
        return this.underlyingHeaders.getLong((Object)"content-length");
    }

    @Override
    public Status getStatus() {
        return Status.valueOf((int)this.getStatusCode());
    }

    @Override
    public int getStatusCode() {
        return this.underlyingHeaders.getInt((Object)Http2Headers.PseudoHeaderName.STATUS.value());
    }

    @Override
    public boolean contains(CharSequence name) {
        return this.underlyingHeaders.contains((Object)name);
    }

    @Override
    public boolean contains(CharSequence name, CharSequence value) {
        return this.underlyingHeaders.contains(name, value, true);
    }
}

