/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.Response;
import io.inverno.mod.http.server.ResponseTrailers;
import io.inverno.mod.http.server.internal.AbstractResponse;
import io.inverno.mod.http.server.internal.http2.Http2ResponseHeaders;
import io.inverno.mod.http.server.internal.http2.Http2ResponseTrailers;
import io.netty.channel.ChannelHandlerContext;
import java.util.function.Consumer;

class Http2Response
extends AbstractResponse {
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;

    public Http2Response(ChannelHandlerContext context, HeaderService headerService, ObjectConverter<String> parameterConverter) {
        super(context, headerService, new Http2ResponseHeaders(headerService, parameterConverter));
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
    }

    @Override
    public Http2ResponseHeaders headers() {
        return (Http2ResponseHeaders)this.responseHeaders;
    }

    @Override
    public Response trailers(Consumer<ResponseTrailers> trailersConfigurer) {
        if (this.responseTrailers == null) {
            this.responseTrailers = new Http2ResponseTrailers(this.headerService, this.parameterConverter);
        }
        trailersConfigurer.accept(this.responseTrailers);
        return this;
    }

    @Override
    public Http2ResponseTrailers trailers() {
        return (Http2ResponseTrailers)this.responseTrailers;
    }
}

