/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.base.net.URIBuilder;
import io.inverno.mod.base.net.URIs;
import io.inverno.mod.http.base.Method;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.RequestHeaders;
import io.inverno.mod.http.server.internal.AbstractRequest;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.netty.channel.ChannelHandlerContext;

public class Http2Request
extends AbstractRequest {
    private URIBuilder pathBuilder;
    private Method method;
    private String scheme;
    private String authority;
    private String path;

    public Http2Request(ChannelHandlerContext context, RequestHeaders requestHeaders, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder) {
        super(context, requestHeaders, parameterConverter, urlEncodedBodyDecoder, multipartBodyDecoder);
    }

    @Override
    protected URIBuilder getPrimaryPathBuilder() {
        if (this.pathBuilder == null) {
            this.pathBuilder = this.requestHeaders.get(":path").map(path -> URIs.uri((String)path, (boolean)false, (URIs.Option[])new URIs.Option[]{URIs.Option.NORMALIZED})).orElseThrow(() -> new IllegalStateException("Request has no :path"));
        }
        return this.pathBuilder;
    }

    @Override
    public Method getMethod() {
        if (this.method == null) {
            this.method = this.requestHeaders.get(":method").map(Method::valueOf).orElse(null);
        }
        return this.method;
    }

    @Override
    public String getScheme() {
        if (this.scheme == null) {
            this.scheme = this.requestHeaders.get(":scheme").orElse(null);
        }
        return this.scheme;
    }

    @Override
    public String getAuthority() {
        if (this.authority == null) {
            this.authority = this.requestHeaders.get(":authority").orElse(null);
        }
        return this.authority;
    }

    @Override
    public String getPath() {
        if (this.path == null) {
            this.path = this.requestHeaders.get(":path").orElse(null);
        }
        return this.path;
    }
}

