/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http2;

import io.inverno.core.annotation.Bean;
import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.ExchangeHandler;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.internal.http2.Http2ChannelHandler;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.netty.handler.codec.http2.AbstractHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.CompressorHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Settings;
import java.util.Optional;
import java.util.function.Supplier;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class Http2ChannelHandlerFactory
implements Supplier<Http2ChannelHandler> {
    private HttpServerConfiguration configuration;
    private ExchangeHandler<Exchange> rootHandler;
    private ExchangeHandler<ErrorExchange<Throwable>> errorHandler;
    private HeaderService headerService;
    private ObjectConverter<String> parameterConverter;
    private MultipartDecoder<Parameter> urlEncodedBodyDecoder;
    private MultipartDecoder<Part> multipartBodyDecoder;

    public Http2ChannelHandlerFactory(HttpServerConfiguration configuration, ExchangeHandler<Exchange> rootHandler, ExchangeHandler<ErrorExchange<Throwable>> errorHandler, HeaderService headerService, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder) {
        this.configuration = configuration;
        this.rootHandler = rootHandler;
        this.errorHandler = errorHandler;
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.urlEncodedBodyDecoder = urlEncodedBodyDecoder;
        this.multipartBodyDecoder = multipartBodyDecoder;
    }

    @Override
    public Http2ChannelHandler get() {
        return new Http2ChannelHandlerBuilder().build();
    }

    private class Http2ChannelHandlerBuilder
    extends AbstractHttp2ConnectionHandlerBuilder<Http2ChannelHandler, Http2ChannelHandlerBuilder>
    implements Supplier<Http2ChannelHandler> {
        public Http2ChannelHandlerBuilder() {
            Http2Settings initialSettings = this.initialSettings();
            Optional.ofNullable(Http2ChannelHandlerFactory.this.configuration.http2_header_table_size()).ifPresent(arg_0 -> ((Http2Settings)initialSettings).headerTableSize(arg_0));
            Optional.ofNullable(Http2ChannelHandlerFactory.this.configuration.http2_max_concurrent_streams()).ifPresent(arg_0 -> ((Http2Settings)initialSettings).maxConcurrentStreams(arg_0));
            Optional.ofNullable(Http2ChannelHandlerFactory.this.configuration.http2_initial_window_size()).ifPresent(arg_0 -> ((Http2Settings)initialSettings).initialWindowSize(arg_0));
            Optional.ofNullable(Http2ChannelHandlerFactory.this.configuration.http2_max_frame_size()).ifPresent(arg_0 -> ((Http2Settings)initialSettings).maxFrameSize(arg_0));
            Optional.ofNullable(Http2ChannelHandlerFactory.this.configuration.http2_max_header_list_size()).ifPresent(arg_0 -> ((Http2Settings)initialSettings).maxHeaderListSize(arg_0));
        }

        @Override
        public Http2ChannelHandler get() {
            return this.build();
        }

        protected Http2ChannelHandler build(Http2ConnectionDecoder decoder, Http2ConnectionEncoder encoder, Http2Settings initialSettings) throws Exception {
            if (Http2ChannelHandlerFactory.this.configuration.compression_enabled()) {
                encoder = new CompressorHttp2ConnectionEncoder(encoder, Http2ChannelHandlerFactory.this.configuration.compression_level(), 15, 8);
            }
            Http2ChannelHandler handler = new Http2ChannelHandler(Http2ChannelHandlerFactory.this.configuration, decoder, encoder, initialSettings, Http2ChannelHandlerFactory.this.rootHandler, Http2ChannelHandlerFactory.this.errorHandler, Http2ChannelHandlerFactory.this.headerService, (ObjectConverter<String>)Http2ChannelHandlerFactory.this.parameterConverter, Http2ChannelHandlerFactory.this.urlEncodedBodyDecoder, Http2ChannelHandlerFactory.this.multipartBodyDecoder);
            this.frameListener(handler);
            return handler;
        }

        public Http2ChannelHandler build() {
            return (Http2ChannelHandler)super.build();
        }
    }
}

