/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.resource.Resource;
import io.inverno.mod.base.resource.ZipResource;
import io.inverno.mod.http.base.InternalServerErrorException;
import io.inverno.mod.http.base.NotFoundException;
import io.inverno.mod.http.server.ResponseBody;
import io.inverno.mod.http.server.internal.GenericResponseBody;
import io.inverno.mod.http.server.internal.http1x.Http1xResponse;
import io.netty.buffer.ByteBuf;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.FileRegion;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.Optional;
import org.reactivestreams.Publisher;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;

class Http1xResponseBody
extends GenericResponseBody {
    private static final int MAX_FILE_REGION_SIZE = 0x100000;
    private Publisher<FileRegion> fileRegionData;

    public Http1xResponseBody(Http1xResponse response) {
        super(response);
    }

    public Optional<Publisher<FileRegion>> getFileRegionData() {
        return Optional.ofNullable(this.fileRegionData);
    }

    @Override
    public ResponseBody.Resource resource() {
        if (!((Http1xResponse)this.response).supportsFileRegion()) {
            return super.resource();
        }
        if (this.resourceData == null) {
            this.resourceData = new Http1xResponseBodyResourceData();
        }
        return this.resourceData;
    }

    private class Http1xResponseBodyResourceData
    extends GenericResponseBody.GenericResponseBodyResourceData {
        private Http1xResponseBodyResourceData() {
            super(Http1xResponseBody.this);
        }

        @Override
        public void value(Resource resource) {
            if (resource.exists().orElse(true).booleanValue()) {
                this.populateHeaders(resource);
                if (resource.isFile().orElse(false).booleanValue() && !(resource instanceof ZipResource)) {
                    FileChannel fileChannel = (FileChannel)resource.openReadableByteChannel().orElseThrow(() -> new InternalServerErrorException("Resource " + resource + " is not readable"));
                    long size = (Long)resource.size().get();
                    int count = (int)Math.ceil((float)size / 1048576.0f);
                    Http1xResponseBody.this.fileRegionData = (Publisher)Flux.range((int)0, (int)(count + 1)).filter(index -> index < count).map(index -> {
                        long position = index * 0x100000;
                        DefaultFileRegion region = new DefaultFileRegion(fileChannel, position, Math.min(size - position, 0x100000L));
                        region.retain();
                        return region;
                    }).doFinally(sgn -> {
                        try {
                            fileChannel.close();
                        }
                        catch (IOException e) {
                            Exceptions.propagate((Throwable)e);
                        }
                    });
                    Http1xResponseBody.this.setData((Publisher<ByteBuf>)((Publisher)Flux.empty()));
                } else {
                    Http1xResponseBody.this.setData((Publisher<ByteBuf>)((Publisher)resource.read().orElseThrow(() -> new InternalServerErrorException("Resource " + resource + " is not readable"))));
                }
            } else {
                throw new NotFoundException();
            }
        }
    }
}

