/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.Response;
import io.inverno.mod.http.server.ResponseTrailers;
import io.inverno.mod.http.server.internal.AbstractResponse;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseBody;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseHeaders;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseTrailers;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.ssl.SslHandler;
import java.util.function.Consumer;

class Http1xResponse
extends AbstractResponse {
    private final HeaderService headerService;
    private final ObjectConverter<String> parameterConverter;

    public Http1xResponse(ChannelHandlerContext context, HeaderService headerService, ObjectConverter<String> parameterConverter) {
        super(context, headerService, new Http1xResponseHeaders(headerService, parameterConverter));
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.responseBody = new Http1xResponseBody(this);
    }

    protected boolean supportsFileRegion() {
        return this.context.pipeline().get(SslHandler.class) == null && this.context.pipeline().get(HttpContentCompressor.class) == null;
    }

    @Override
    public Response trailers(Consumer<ResponseTrailers> trailersConfigurer) {
        if (this.responseTrailers == null) {
            this.responseTrailers = new Http1xResponseTrailers(this.headerService, this.parameterConverter);
        }
        trailersConfigurer.accept(this.responseTrailers);
        return this;
    }

    @Override
    public Http1xResponseHeaders headers() {
        return (Http1xResponseHeaders)this.responseHeaders;
    }

    @Override
    public Http1xResponseTrailers trailers() {
        return (Http1xResponseTrailers)this.responseTrailers;
    }

    @Override
    public Http1xResponseBody body() {
        return (Http1xResponseBody)super.body();
    }
}

