/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal.http1x;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Parameter;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.server.ErrorExchange;
import io.inverno.mod.http.server.Exchange;
import io.inverno.mod.http.server.ExchangeHandler;
import io.inverno.mod.http.server.Part;
import io.inverno.mod.http.server.internal.AbstractExchange;
import io.inverno.mod.http.server.internal.http1x.Http1xConnectionEncoder;
import io.inverno.mod.http.server.internal.http1x.Http1xExchange;
import io.inverno.mod.http.server.internal.multipart.MultipartDecoder;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Http1xChannelHandler
extends ChannelDuplexHandler
implements Http1xConnectionEncoder,
AbstractExchange.Handler {
    private static final Logger LOGGER = LogManager.getLogger(Http1xChannelHandler.class);
    private Http1xExchange requestingExchange;
    private Http1xExchange respondingExchange;
    private Http1xExchange exchangeQueue;
    private ExchangeHandler<Exchange> rootHandler;
    private ExchangeHandler<ErrorExchange<Throwable>> errorHandler;
    private HeaderService headerService;
    private ObjectConverter<String> parameterConverter;
    private MultipartDecoder<Parameter> urlEncodedBodyDecoder;
    private MultipartDecoder<Part> multipartBodyDecoder;
    private boolean read;
    private boolean flush;

    public Http1xChannelHandler(ExchangeHandler<Exchange> rootHandler, ExchangeHandler<ErrorExchange<Throwable>> errorHandler, HeaderService headerService, ObjectConverter<String> parameterConverter, MultipartDecoder<Parameter> urlEncodedBodyDecoder, MultipartDecoder<Part> multipartBodyDecoder) {
        this.rootHandler = rootHandler;
        this.errorHandler = errorHandler;
        this.headerService = headerService;
        this.parameterConverter = parameterConverter;
        this.urlEncodedBodyDecoder = urlEncodedBodyDecoder;
        this.multipartBodyDecoder = multipartBodyDecoder;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        this.read = true;
        if (msg instanceof HttpRequest) {
            HttpRequest httpRequest = (HttpRequest)msg;
            if (httpRequest.decoderResult().isFailure()) {
                this.onDecoderError(ctx, (HttpObject)httpRequest);
                return;
            }
            this.requestingExchange = new Http1xExchange(ctx, httpRequest, this, this.headerService, this.parameterConverter, this.urlEncodedBodyDecoder, this.multipartBodyDecoder, this.rootHandler, this.errorHandler);
            if (this.exchangeQueue == null) {
                this.exchangeQueue = this.requestingExchange;
                this.requestingExchange.start(this);
            } else {
                this.exchangeQueue.next = this.requestingExchange;
                this.exchangeQueue = this.requestingExchange;
            }
        } else if (this.requestingExchange != null) {
            if (msg == LastHttpContent.EMPTY_LAST_CONTENT) {
                this.requestingExchange.request().data().ifPresent(sink -> sink.tryEmitComplete());
            } else {
                HttpContent httpContent = (HttpContent)msg;
                if (httpContent.decoderResult().isFailure()) {
                    this.onDecoderError(ctx, (HttpObject)httpContent);
                    return;
                }
                this.requestingExchange.request().data().ifPresentOrElse(emitter -> emitter.tryEmitNext((Object)httpContent.content()), () -> httpContent.release());
                if (httpContent instanceof LastHttpContent) {
                    this.requestingExchange.request().data().ifPresent(sink -> sink.tryEmitComplete());
                }
            }
        } else {
            ((HttpContent)msg).release();
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.read) {
            this.read = false;
            if (this.flush) {
                ctx.flush();
                this.flush = false;
            }
        }
    }

    private void onDecoderError(ChannelHandlerContext ctx, HttpObject httpObject) {
        Throwable cause = httpObject.decoderResult().cause();
        if (cause instanceof TooLongFrameException) {
            String causeMsg = cause.getMessage();
            HttpResponseStatus status = causeMsg.startsWith("An HTTP line is larger than") ? HttpResponseStatus.REQUEST_URI_TOO_LONG : (causeMsg.startsWith("HTTP header is larger than") ? HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE : HttpResponseStatus.BAD_REQUEST);
            ChannelPromise writePromise = ctx.newPromise();
            ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status), writePromise);
            writePromise.addListener(res -> ctx.fireExceptionCaught(cause));
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        ctx.fireUserEventTriggered(evt);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.close();
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        ctx.close();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.respondingExchange != null) {
            this.respondingExchange.dispose();
        }
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
    }

    @Override
    public ChannelFuture writeFrame(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (this.read) {
            this.flush = true;
            return ctx.write(msg, promise);
        }
        return ctx.writeAndFlush(msg, promise);
    }

    @Override
    public void exchangeStart(ChannelHandlerContext ctx, AbstractExchange exchange) {
        this.respondingExchange = (Http1xExchange)exchange;
    }

    @Override
    public void exchangeError(ChannelHandlerContext ctx, Throwable t) {
        LOGGER.error((Object)t);
        if (this.flush) {
            ctx.flush();
        }
        if (this.respondingExchange.next != null) {
            this.respondingExchange.next.dispose();
        }
        ctx.close();
    }

    @Override
    public void exchangeComplete(ChannelHandlerContext ctx) {
        if (this.respondingExchange.keepAlive) {
            if (this.respondingExchange.next != null) {
                this.respondingExchange.next.start(this);
            } else {
                this.exchangeQueue = null;
                this.respondingExchange = null;
            }
        } else {
            if (this.respondingExchange.next != null) {
                this.respondingExchange.next.dispose();
            }
            ctx.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

