/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.server.internal;

import io.inverno.core.annotation.Bean;
import io.inverno.core.annotation.Lazy;
import io.inverno.mod.base.net.NetService;
import io.inverno.mod.http.server.HttpServerConfiguration;
import io.inverno.mod.http.server.internal.HttpProtocolNegotiationHandler;
import io.inverno.mod.http.server.internal.http1x.Http1xChannelHandler;
import io.inverno.mod.http.server.internal.http1x.Http1xRequestDecoder;
import io.inverno.mod.http.server.internal.http1x.Http1xResponseEncoder;
import io.inverno.mod.http.server.internal.http2.H2cUpgradeHandler;
import io.inverno.mod.http.server.internal.http2.Http2ChannelHandler;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.ssl.ApplicationProtocolNegotiationHandler;
import io.netty.handler.ssl.SslContext;
import java.util.function.Supplier;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class HttpChannelConfigurer {
    private final HttpServerConfiguration configuration;
    private final ApplicationProtocolNegotiationHandler protocolNegotiationHandler;
    private SslContext sslContext;
    private final ByteBufAllocator allocator;
    private final ByteBufAllocator directAllocator;
    private final Supplier<Http1xChannelHandler> http1xChannelHandlerFactory;
    private final Supplier<Http2ChannelHandler> http2ChannelHandlerFactory;

    public HttpChannelConfigurer(HttpServerConfiguration configuration, NetService netService, @Lazy Supplier<SslContext> sslContextSupplier, Supplier<Http1xChannelHandler> http1xChannelHandlerFactory, Supplier<Http2ChannelHandler> http2ChannelHandlerFactory) {
        this.configuration = configuration;
        this.allocator = netService.getByteBufAllocator();
        this.directAllocator = netService.getDirectByteBufAllocator();
        this.http1xChannelHandlerFactory = http1xChannelHandlerFactory;
        this.http2ChannelHandlerFactory = http2ChannelHandlerFactory;
        this.protocolNegotiationHandler = new HttpProtocolNegotiationHandler(this);
        if (this.configuration.tls_enabled()) {
            this.sslContext = sslContextSupplier.get();
        }
    }

    public void configure(ChannelPipeline pipeline) {
        if (this.configuration.tls_enabled()) {
            pipeline.addLast("sslHandler", (ChannelHandler)this.sslContext.newHandler(this.allocator));
            if (this.configuration.h2_enabled()) {
                pipeline.addLast("protocolNegotiationHandler", (ChannelHandler)this.protocolNegotiationHandler);
            } else {
                this.configureHttp1x(pipeline);
            }
        } else if (this.configuration.h2c_enabled()) {
            this.configureH2C(pipeline);
        } else {
            this.configureHttp1x(pipeline);
        }
    }

    private void initHttp1x(ChannelPipeline pipeline) {
        pipeline.addLast("http1xDecoder", (ChannelHandler)new Http1xRequestDecoder());
        pipeline.addLast("http1xEncoder", (ChannelHandler)new Http1xResponseEncoder(this.directAllocator));
        if (this.configuration.decompression_enabled()) {
            pipeline.addLast("http1xDecompressor", (ChannelHandler)new HttpContentDecompressor(false));
        }
        if (this.configuration.compression_enabled()) {
            pipeline.addLast("http1xCompressor", (ChannelHandler)new HttpContentCompressor(this.configuration.compression_level()));
        }
    }

    private Http1xChannelHandler handleHttp1x(ChannelPipeline pipeline) {
        Http1xChannelHandler handler = this.http1xChannelHandlerFactory.get();
        pipeline.addLast("http1xHandler", (ChannelHandler)handler);
        return handler;
    }

    private Http2ChannelHandler handleHttp2(ChannelPipeline pipeline) {
        Http2ChannelHandler handler = this.http2ChannelHandlerFactory.get();
        pipeline.addLast("http2Handler", (ChannelHandler)handler);
        return handler;
    }

    public Http1xChannelHandler configureHttp1x(ChannelPipeline pipeline) {
        this.initHttp1x(pipeline);
        return this.handleHttp1x(pipeline);
    }

    public void configureH2C(ChannelPipeline pipeline) {
        this.initHttp1x(pipeline);
        pipeline.addLast("h2cUpgradeHandler", (ChannelHandler)new H2cUpgradeHandler(this));
        this.handleHttp1x(pipeline);
    }

    public Http2ChannelHandler upgradeToHttp2(ChannelPipeline pipeline) {
        pipeline.remove("http1xDecoder");
        pipeline.remove("http1xEncoder");
        if (this.configuration.decompression_enabled()) {
            pipeline.remove("http1xDecompressor");
        }
        if (this.configuration.compression_enabled()) {
            pipeline.remove("http1xCompressor");
        }
        pipeline.remove("h2cUpgradeHandler");
        pipeline.remove("http1xHandler");
        return this.handleHttp2(pipeline);
    }

    public Http2ChannelHandler configureHttp2(ChannelPipeline pipeline) {
        return this.handleHttp2(pipeline);
    }
}

