package io.inverno.mod.http.server;

import io.inverno.core.annotation.Overridable;
import io.inverno.core.annotation.Wrapper;
import io.inverno.mod.configuration.ConfigurationKey.Parameter;
import io.inverno.mod.configuration.ConfigurationLoaderSupport;
import io.inverno.mod.configuration.ConfigurationSource;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.String;
import java.net.URI;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public final class HttpServerConfigurationLoader extends ConfigurationLoaderSupport<HttpServerConfiguration, HttpServerConfigurationLoader.Configurator, HttpServerConfigurationLoader> {

	public HttpServerConfigurationLoader() {
		super(
			new String[] {
				"io.inverno.mod.http.server.httpServerConfiguration.server_host",
				"io.inverno.mod.http.server.httpServerConfiguration.server_port",
				"io.inverno.mod.http.server.httpServerConfiguration.server_event_loop_group_size",
				"io.inverno.mod.http.server.httpServerConfiguration.key_store_type",
				"io.inverno.mod.http.server.httpServerConfiguration.compression_enabled",
				"io.inverno.mod.http.server.httpServerConfiguration.decompression_enabled",
				"io.inverno.mod.http.server.httpServerConfiguration.compression_level",
				"io.inverno.mod.http.server.httpServerConfiguration.tls_enabled",
				"io.inverno.mod.http.server.httpServerConfiguration.h2c_enabled",
				"io.inverno.mod.http.server.httpServerConfiguration.h2_enabled",
				"io.inverno.mod.http.server.httpServerConfiguration.key_store",
				"io.inverno.mod.http.server.httpServerConfiguration.key_store_password",
				"io.inverno.mod.http.server.httpServerConfiguration.tls_ciphers_includes",
				"io.inverno.mod.http.server.httpServerConfiguration.tls_ciphers_excludes",
				"io.inverno.mod.http.server.httpServerConfiguration.http2_header_table_size",
				"io.inverno.mod.http.server.httpServerConfiguration.http2_max_concurrent_streams",
				"io.inverno.mod.http.server.httpServerConfiguration.http2_initial_window_size",
				"io.inverno.mod.http.server.httpServerConfiguration.http2_max_frame_size",
				"io.inverno.mod.http.server.httpServerConfiguration.http2_max_header_list_size"
			},
			results -> httpServerConfiguration_configurator -> {
				results.get(0).getResult().ifPresent(property -> httpServerConfiguration_configurator.server_host(property.as(String.class).orElse(null)));
				results.get(1).getResult().ifPresent(property -> httpServerConfiguration_configurator.server_port(property.asInteger().orElseGet(() -> (new int[1])[0])));
				results.get(2).getResult().ifPresent(property -> httpServerConfiguration_configurator.server_event_loop_group_size(property.as(Integer.class).orElse(null)));
				results.get(3).getResult().ifPresent(property -> httpServerConfiguration_configurator.key_store_type(property.as(String.class).orElse(null)));
				results.get(4).getResult().ifPresent(property -> httpServerConfiguration_configurator.compression_enabled(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
				results.get(5).getResult().ifPresent(property -> httpServerConfiguration_configurator.decompression_enabled(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
				results.get(6).getResult().ifPresent(property -> httpServerConfiguration_configurator.compression_level(property.asInteger().orElseGet(() -> (new int[1])[0])));
				results.get(7).getResult().ifPresent(property -> httpServerConfiguration_configurator.tls_enabled(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
				results.get(8).getResult().ifPresent(property -> httpServerConfiguration_configurator.h2c_enabled(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
				results.get(9).getResult().ifPresent(property -> httpServerConfiguration_configurator.h2_enabled(property.asBoolean().orElseGet(() -> (new boolean[1])[0])));
				results.get(10).getResult().ifPresent(property -> httpServerConfiguration_configurator.key_store(property.as(URI.class).orElse(null)));
				results.get(11).getResult().ifPresent(property -> httpServerConfiguration_configurator.key_store_password(property.as(String.class).orElse(null)));
				results.get(12).getResult().ifPresent(property -> httpServerConfiguration_configurator.tls_ciphers_includes(property.asArrayOf(String.class).orElse(null)));
				results.get(13).getResult().ifPresent(property -> httpServerConfiguration_configurator.tls_ciphers_excludes(property.asArrayOf(String.class).orElse(null)));
				results.get(14).getResult().ifPresent(property -> httpServerConfiguration_configurator.http2_header_table_size(property.as(Long.class).orElse(null)));
				results.get(15).getResult().ifPresent(property -> httpServerConfiguration_configurator.http2_max_concurrent_streams(property.as(Integer.class).orElse(null)));
				results.get(16).getResult().ifPresent(property -> httpServerConfiguration_configurator.http2_initial_window_size(property.as(Integer.class).orElse(null)));
				results.get(17).getResult().ifPresent(property -> httpServerConfiguration_configurator.http2_max_frame_size(property.as(Integer.class).orElse(null)));
				results.get(18).getResult().ifPresent(property -> httpServerConfiguration_configurator.http2_max_header_list_size(property.as(Integer.class).orElse(null)));
			},
			HttpServerConfigurationLoader::load,
			HttpServerConfigurationLoader.Configuration::new
		);
	}

	public static HttpServerConfiguration load(Consumer<HttpServerConfigurationLoader.Configurator> configurer) {
		HttpServerConfigurationLoader.Configurator configurator = new HttpServerConfigurationLoader.Configurator();
		configurer.accept(configurator);
		return new HttpServerConfigurationLoader.Configuration(configurator.server_host, configurator.server_port, configurator.server_event_loop_group_size, configurator.key_store_type, configurator.compression_enabled, configurator.decompression_enabled, configurator.compression_level, configurator.tls_enabled, configurator.h2c_enabled, configurator.h2_enabled, configurator.key_store, configurator.key_store_password, configurator.tls_ciphers_includes, configurator.tls_ciphers_excludes, configurator.http2_header_table_size, configurator.http2_max_concurrent_streams, configurator.http2_initial_window_size, configurator.http2_max_frame_size, configurator.http2_max_header_list_size);
	}

	private static final class Configuration implements HttpServerConfiguration {

		private String server_host = HttpServerConfiguration.super.server_host();
		private int server_port = HttpServerConfiguration.super.server_port();
		private Integer server_event_loop_group_size;
		private String key_store_type = HttpServerConfiguration.super.key_store_type();
		private boolean compression_enabled = HttpServerConfiguration.super.compression_enabled();
		private boolean decompression_enabled = HttpServerConfiguration.super.decompression_enabled();
		private int compression_level = HttpServerConfiguration.super.compression_level();
		private boolean tls_enabled = HttpServerConfiguration.super.tls_enabled();
		private boolean h2c_enabled = HttpServerConfiguration.super.h2c_enabled();
		private boolean h2_enabled = HttpServerConfiguration.super.h2_enabled();
		private URI key_store;
		private String key_store_password;
		private String[] tls_ciphers_includes;
		private String[] tls_ciphers_excludes;
		private Long http2_header_table_size = HttpServerConfiguration.super.http2_header_table_size();
		private Integer http2_max_concurrent_streams = HttpServerConfiguration.super.http2_max_concurrent_streams();
		private Integer http2_initial_window_size = HttpServerConfiguration.super.http2_initial_window_size();
		private Integer http2_max_frame_size = HttpServerConfiguration.super.http2_max_frame_size();
		private Integer http2_max_header_list_size = HttpServerConfiguration.super.http2_max_header_list_size();

		private Configuration() {}

		public Configuration(Supplier<String> server_host, Supplier<Integer> server_port, Supplier<Integer> server_event_loop_group_size, Supplier<String> key_store_type, Supplier<Boolean> compression_enabled, Supplier<Boolean> decompression_enabled, Supplier<Integer> compression_level, Supplier<Boolean> tls_enabled, Supplier<Boolean> h2c_enabled, Supplier<Boolean> h2_enabled, Supplier<URI> key_store, Supplier<String> key_store_password, Supplier<String[]> tls_ciphers_includes, Supplier<String[]> tls_ciphers_excludes, Supplier<Long> http2_header_table_size, Supplier<Integer> http2_max_concurrent_streams, Supplier<Integer> http2_initial_window_size, Supplier<Integer> http2_max_frame_size, Supplier<Integer> http2_max_header_list_size) {
			Optional.ofNullable(server_host).ifPresent(s -> this.server_host = s.get());
			Optional.ofNullable(server_port).ifPresent(s -> this.server_port = s.get());
			Optional.ofNullable(server_event_loop_group_size).ifPresent(s -> this.server_event_loop_group_size = s.get());
			Optional.ofNullable(key_store_type).ifPresent(s -> this.key_store_type = s.get());
			Optional.ofNullable(compression_enabled).ifPresent(s -> this.compression_enabled = s.get());
			Optional.ofNullable(decompression_enabled).ifPresent(s -> this.decompression_enabled = s.get());
			Optional.ofNullable(compression_level).ifPresent(s -> this.compression_level = s.get());
			Optional.ofNullable(tls_enabled).ifPresent(s -> this.tls_enabled = s.get());
			Optional.ofNullable(h2c_enabled).ifPresent(s -> this.h2c_enabled = s.get());
			Optional.ofNullable(h2_enabled).ifPresent(s -> this.h2_enabled = s.get());
			Optional.ofNullable(key_store).ifPresent(s -> this.key_store = s.get());
			Optional.ofNullable(key_store_password).ifPresent(s -> this.key_store_password = s.get());
			Optional.ofNullable(tls_ciphers_includes).ifPresent(s -> this.tls_ciphers_includes = s.get());
			Optional.ofNullable(tls_ciphers_excludes).ifPresent(s -> this.tls_ciphers_excludes = s.get());
			Optional.ofNullable(http2_header_table_size).ifPresent(s -> this.http2_header_table_size = s.get());
			Optional.ofNullable(http2_max_concurrent_streams).ifPresent(s -> this.http2_max_concurrent_streams = s.get());
			Optional.ofNullable(http2_initial_window_size).ifPresent(s -> this.http2_initial_window_size = s.get());
			Optional.ofNullable(http2_max_frame_size).ifPresent(s -> this.http2_max_frame_size = s.get());
			Optional.ofNullable(http2_max_header_list_size).ifPresent(s -> this.http2_max_header_list_size = s.get());
		}

		public String server_host() {
			 return this.server_host;
		}

		public int server_port() {
			 return this.server_port;
		}

		public Integer server_event_loop_group_size() {
			 return this.server_event_loop_group_size;
		}

		public String key_store_type() {
			 return this.key_store_type;
		}

		public boolean compression_enabled() {
			 return this.compression_enabled;
		}

		public boolean decompression_enabled() {
			 return this.decompression_enabled;
		}

		public int compression_level() {
			 return this.compression_level;
		}

		public boolean tls_enabled() {
			 return this.tls_enabled;
		}

		public boolean h2c_enabled() {
			 return this.h2c_enabled;
		}

		public boolean h2_enabled() {
			 return this.h2_enabled;
		}

		public URI key_store() {
			 return this.key_store;
		}

		public String key_store_password() {
			 return this.key_store_password;
		}

		public String[] tls_ciphers_includes() {
			 return this.tls_ciphers_includes;
		}

		public String[] tls_ciphers_excludes() {
			 return this.tls_ciphers_excludes;
		}

		public Long http2_header_table_size() {
			 return this.http2_header_table_size;
		}

		public Integer http2_max_concurrent_streams() {
			 return this.http2_max_concurrent_streams;
		}

		public Integer http2_initial_window_size() {
			 return this.http2_initial_window_size;
		}

		public Integer http2_max_frame_size() {
			 return this.http2_max_frame_size;
		}

		public Integer http2_max_header_list_size() {
			 return this.http2_max_header_list_size;
		}
	}

	public static final class Configurator {

		private Supplier<String> server_host;
		private Supplier<Integer> server_port;
		private Supplier<Integer> server_event_loop_group_size;
		private Supplier<String> key_store_type;
		private Supplier<Boolean> compression_enabled;
		private Supplier<Boolean> decompression_enabled;
		private Supplier<Integer> compression_level;
		private Supplier<Boolean> tls_enabled;
		private Supplier<Boolean> h2c_enabled;
		private Supplier<Boolean> h2_enabled;
		private Supplier<URI> key_store;
		private Supplier<String> key_store_password;
		private Supplier<String[]> tls_ciphers_includes;
		private Supplier<String[]> tls_ciphers_excludes;
		private Supplier<Long> http2_header_table_size;
		private Supplier<Integer> http2_max_concurrent_streams;
		private Supplier<Integer> http2_initial_window_size;
		private Supplier<Integer> http2_max_frame_size;
		private Supplier<Integer> http2_max_header_list_size;

		private Configurator() {}

		public Configurator server_host(String server_host) {
			this.server_host = () -> server_host;
			return this;
		}

		public Configurator server_port(int server_port) {
			this.server_port = () -> server_port;
			return this;
		}

		public Configurator server_event_loop_group_size(Integer server_event_loop_group_size) {
			this.server_event_loop_group_size = () -> server_event_loop_group_size;
			return this;
		}

		public Configurator key_store_type(String key_store_type) {
			this.key_store_type = () -> key_store_type;
			return this;
		}

		public Configurator compression_enabled(boolean compression_enabled) {
			this.compression_enabled = () -> compression_enabled;
			return this;
		}

		public Configurator decompression_enabled(boolean decompression_enabled) {
			this.decompression_enabled = () -> decompression_enabled;
			return this;
		}

		public Configurator compression_level(int compression_level) {
			this.compression_level = () -> compression_level;
			return this;
		}

		public Configurator tls_enabled(boolean tls_enabled) {
			this.tls_enabled = () -> tls_enabled;
			return this;
		}

		public Configurator h2c_enabled(boolean h2c_enabled) {
			this.h2c_enabled = () -> h2c_enabled;
			return this;
		}

		public Configurator h2_enabled(boolean h2_enabled) {
			this.h2_enabled = () -> h2_enabled;
			return this;
		}

		public Configurator key_store(URI key_store) {
			this.key_store = () -> key_store;
			return this;
		}

		public Configurator key_store_password(String key_store_password) {
			this.key_store_password = () -> key_store_password;
			return this;
		}

		public Configurator tls_ciphers_includes(String[] tls_ciphers_includes) {
			this.tls_ciphers_includes = () -> tls_ciphers_includes;
			return this;
		}

		public Configurator tls_ciphers_excludes(String[] tls_ciphers_excludes) {
			this.tls_ciphers_excludes = () -> tls_ciphers_excludes;
			return this;
		}

		public Configurator http2_header_table_size(Long http2_header_table_size) {
			this.http2_header_table_size = () -> http2_header_table_size;
			return this;
		}

		public Configurator http2_max_concurrent_streams(Integer http2_max_concurrent_streams) {
			this.http2_max_concurrent_streams = () -> http2_max_concurrent_streams;
			return this;
		}

		public Configurator http2_initial_window_size(Integer http2_initial_window_size) {
			this.http2_initial_window_size = () -> http2_initial_window_size;
			return this;
		}

		public Configurator http2_max_frame_size(Integer http2_max_frame_size) {
			this.http2_max_frame_size = () -> http2_max_frame_size;
			return this;
		}

		public Configurator http2_max_header_list_size(Integer http2_max_header_list_size) {
			this.http2_max_header_list_size = () -> http2_max_header_list_size;
			return this;
		}
	}

	@io.inverno.core.annotation.Bean(name = "httpServerConfiguration")
	@Wrapper
	@Overridable
	public static final class Bean extends ConfigurationLoaderSupport.ConfigurationBeanSupport<HttpServerConfiguration, HttpServerConfigurationLoader.Configurator, HttpServerConfigurationLoader> implements Supplier<HttpServerConfiguration> {

		public Bean() {
			super(new HttpServerConfigurationLoader());
		}

		public void setConfigurationSource(ConfigurationSource<?, ?, ?> source) {
			this.loader.withSource(source);
		}

		public void setParameters(Parameter[] parameters) {
			this.loader.withParameters(parameters);
		}

		public void setConfigurer(Consumer<HttpServerConfigurationLoader.Configurator> configurer) {
			this.loader.withConfigurer(configurer);
		}
	}
}