/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.header;

import io.inverno.mod.http.base.header.AbstractHeaderCodec;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderBuilder;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.internal.header.MalformedHeaderException;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.Set;
import java.util.function.Supplier;

public class GenericHeaderCodec<A extends Header, B extends HeaderBuilder<A, B>>
extends AbstractHeaderCodec<A, B> {
    protected GenericHeaderCodec(Supplier<B> builderSupplier, Set<String> supportedHeaderNames) {
        super(builderSupplier, supportedHeaderNames);
    }

    @Override
    public A decode(String name, String value) {
        return ((HeaderBuilder)this.builderSupplier.get()).headerName(name).headerValue(value.trim()).build();
    }

    @Override
    public A decode(String name, ByteBuf buffer, Charset charset) {
        int readerIndex = buffer.readerIndex();
        Object builder = ((HeaderBuilder)this.builderSupplier.get()).headerName(name);
        Integer startIndex = null;
        Integer endIndex = null;
        while (buffer.isReadable()) {
            byte nextByte = buffer.readByte();
            if (startIndex == null && Character.isWhitespace(nextByte)) continue;
            if (startIndex == null) {
                startIndex = buffer.readerIndex() - 1;
            }
            if (nextByte == 13) {
                if (buffer.getByte(buffer.readerIndex()) != 10) continue;
                buffer.readByte();
                endIndex = buffer.readerIndex() - 2;
                if (startIndex == endIndex) {
                    buffer.readerIndex(readerIndex);
                    throw new MalformedHeaderException(name);
                }
                return builder.headerValue(buffer.slice(startIndex.intValue(), endIndex - startIndex).toString(charset)).build();
            }
            if (nextByte == 10) {
                endIndex = buffer.readerIndex() - 1;
                return builder.headerValue(buffer.slice(startIndex.intValue(), endIndex - startIndex).toString(charset)).build();
            }
            if (HeaderService.isContentCharacter((char)nextByte)) continue;
            throw new MalformedHeaderException(name + ": Invalid character " + (char)nextByte);
        }
        buffer.readerIndex(readerIndex);
        return null;
    }

    @Override
    public String encode(A headerField) {
        StringBuilder result = new StringBuilder();
        result.append(headerField.getHeaderName()).append(": ").append(this.encodeValue(headerField));
        return result.toString();
    }

    @Override
    public String encodeValue(A headerField) {
        return headerField.getHeaderValue();
    }
}

