/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.header;

import io.inverno.mod.http.base.header.AbstractHeaderBuilder;
import io.inverno.mod.http.base.header.Header;

public class GenericHeader
implements Header {
    protected String headerName;
    protected String headerValue;

    public GenericHeader(String headerName, String headerValue) {
        this.headerName = headerName.toLowerCase();
        if (headerValue != null) {
            this.headerValue = headerValue.trim();
        }
    }

    @Override
    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderValue(String headerValue) {
        this.headerValue = headerValue;
    }

    @Override
    public String getHeaderValue() {
        return this.headerValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.headerName == null ? 0 : this.headerName.hashCode());
        result = 31 * result + (this.headerValue == null ? 0 : this.headerValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericHeader other = (GenericHeader)obj;
        if (this.headerName == null ? other.headerName != null : !this.headerName.equals(other.headerName)) {
            return false;
        }
        return !(this.headerValue == null ? other.headerValue != null : !this.headerValue.equals(other.headerValue));
    }

    private static final class SimpleHeader
    extends GenericHeader {
        public SimpleHeader(String headerName, String headerValue) {
            super(headerName, headerValue);
        }
    }

    public static class SimpleHeaderBuilder
    extends AbstractHeaderBuilder<Header, SimpleHeaderBuilder> {
        @Override
        public Header build() {
            return new SimpleHeader(this.headerName, this.headerValue);
        }
    }
}

