/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.header;

import io.inverno.core.annotation.Bean;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.internal.header.MalformedHeaderException;
import io.inverno.mod.http.base.internal.header.ParameterizedHeader;
import io.inverno.mod.http.base.internal.header.ParameterizedHeaderCodec;
import java.util.Map;
import java.util.Set;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class ContentDispositionCodec
extends ParameterizedHeaderCodec<ContentDisposition, ContentDisposition.Builder> {
    public ContentDispositionCodec() {
        super(ContentDisposition.Builder::new, Set.of("content-disposition"), ';', ';', ',', false, false, false, false, true, false);
    }

    public static final class ContentDisposition
    extends ParameterizedHeader
    implements Headers.ContentDisposition {
        private final String dispositionType;
        private final String partName;
        private final String filename;
        private final String creationDateTime;
        private final String modificationDatetime;
        private final String readDateTime;
        private final Integer size;

        private ContentDisposition(String headerValue, String dispositionType, Map<String, String> parameters, String partName, String filename, String creationDateTime, String modificationDatetime, String readDateTime, Integer size) {
            super("content-disposition", headerValue, dispositionType, parameters);
            this.dispositionType = dispositionType;
            this.partName = partName;
            this.filename = filename;
            this.creationDateTime = creationDateTime;
            this.modificationDatetime = modificationDatetime;
            this.readDateTime = readDateTime;
            this.size = size;
            if (!HeaderService.isToken(this.dispositionType)) {
                throw new MalformedHeaderException("Invalid content disposition type");
            }
        }

        @Override
        public String getDispositionType() {
            return this.dispositionType;
        }

        @Override
        public String getPartName() {
            return this.partName;
        }

        @Override
        public String getFilename() {
            return this.filename;
        }

        @Override
        public String getCreationDateTime() {
            return this.creationDateTime;
        }

        @Override
        public String getModificationDatetime() {
            return this.modificationDatetime;
        }

        @Override
        public String getReadDateTime() {
            return this.readDateTime;
        }

        @Override
        public Integer getSize() {
            return this.size;
        }

        public static final class Builder
        extends ParameterizedHeader.AbstractBuilder<ContentDisposition, Builder> {
            private String partName;
            private String filename;
            private String creationDateTime;
            private String modificationDatetime;
            private String readDateTime;
            private Integer size;

            @Override
            public Builder parameter(String name, String value) {
                if (name.equals("name")) {
                    this.partName = value;
                } else if (name.equals("filename")) {
                    this.filename = value;
                } else if (name.equals("creation-date")) {
                    this.creationDateTime = value;
                } else if (name.equals("modification-date")) {
                    this.modificationDatetime = value;
                } else if (name.equals("read-date")) {
                    this.readDateTime = value;
                } else if (name.equals("size")) {
                    this.size = Integer.valueOf(value);
                }
                return (Builder)super.parameter(name, value);
            }

            @Override
            public ContentDisposition build() {
                return new ContentDisposition(this.headerValue, this.parameterizedValue, this.parameters, this.partName, this.filename, this.creationDateTime, this.modificationDatetime, this.readDateTime, this.size);
            }
        }
    }
}

