/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Iterator;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class OutboundDataSequencer
implements Function<Flux<ByteBuf>, Flux<ByteBuf>> {
    public static final int DEFAULT_BUFFER_CAPACITY = 8192;
    private final int bufferCapacity;
    private int accumulatedSize;
    private ByteBuf retainedBuffer;

    public OutboundDataSequencer() {
        this(8192);
    }

    public OutboundDataSequencer(int bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
    }

    @Override
    public Flux<ByteBuf> apply(Flux<ByteBuf> data) {
        return data.bufferUntil(buffer -> {
            this.accumulatedSize += buffer.readableBytes();
            return this.accumulatedSize >= this.bufferCapacity;
        }).map(accBuffers -> {
            int index;
            ByteBuf[] buffers;
            if (this.retainedBuffer == null) {
                buffers = new ByteBuf[accBuffers.size()];
                index = 0;
            } else {
                buffers = new ByteBuf[accBuffers.size() + 1];
                buffers[0] = this.retainedBuffer;
                index = 1;
            }
            for (ByteBuf b : accBuffers) {
                buffers[index++] = b;
            }
            ByteBuf buffer = Unpooled.wrappedBuffer((ByteBuf[])buffers);
            if (this.accumulatedSize > this.bufferCapacity) {
                this.retainedBuffer = buffer;
                buffer = buffer.readRetainedSlice(this.bufferCapacity);
                this.accumulatedSize = this.retainedBuffer.readableBytes();
            } else {
                this.retainedBuffer = null;
                this.accumulatedSize = 0;
            }
            return buffer;
        }).concatWith((Publisher)Flux.defer(() -> Mono.justOrEmpty((Object)this.retainedBuffer).flatMapIterable(buffer -> () -> new Iterator<ByteBuf>(){

            @Override
            public boolean hasNext() {
                return buffer.isReadable();
            }

            @Override
            public ByteBuf next() {
                return buffer.readRetainedSlice(Math.min(buffer.readableBytes(), OutboundDataSequencer.this.bufferCapacity));
            }
        })));
    }
}

