/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.header;

import io.inverno.mod.http.base.header.CookieParameter;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.internal.header.AcceptCodec;
import io.inverno.mod.http.base.internal.header.AcceptLanguageCodec;
import java.nio.charset.Charset;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class Headers {
    public static final DateTimeFormatter FORMATTER_RFC_5322_DATE_TIME = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss z", Locale.ENGLISH).withZone(ZoneId.of("GMT"));
    public static final String NAME_ACCEPT = "accept";
    public static final String NAME_ACCEPT_ENCODING = "accept-encoding";
    public static final String NAME_ACCEPT_LANGUAGE = "accept-language";
    public static final String NAME_ACCESS_CONTROL_ALLOW_CREDENTIALS = "access-control-allow-credentials";
    public static final String NAME_ACCESS_CONTROL_ALLOW_HEADERS = "access-control-allow-headers";
    public static final String NAME_ACCESS_CONTROL_ALLOW_METHODS = "access-control-allow-methods";
    public static final String NAME_ACCESS_CONTROL_ALLOW_ORIGIN = "access-control-allow-origin";
    public static final String NAME_ACCESS_CONTROL_ALLOW_PRIVATE_NETWORK = "access-control-allow-private-network";
    public static final String NAME_ACCESS_CONTROL_EXPOSE_HEADERS = "access-control-expose-headers";
    public static final String NAME_ACCESS_CONTROL_MAX_AGE = "access-control-max-age";
    public static final String NAME_ACCESS_CONTROL_REQUEST_METHOD = "access-control-request-method";
    public static final String NAME_ACCESS_CONTROL_REQUEST_HEADERS = "access-control-request-headers";
    public static final String NAME_ACCESS_CONTROL_REQUEST_PRIVATE_NETWORK = "access-control-request-private-network";
    public static final String NAME_ALLOW = "allow";
    public static final String NAME_AUTHORIZATION = "authorization";
    public static final String NAME_CACHE_CONTROL = "cache-control";
    public static final String NAME_CONNECTION = "connection";
    public static final String NAME_CONTENT_DISPOSITION = "content-disposition";
    public static final String NAME_CONTENT_ENCODING = "content-encoding";
    public static final String NAME_EXPECT = "expect";
    public static final String NAME_CONTENT_TYPE = "content-type";
    public static final String NAME_CONTENT_LENGTH = "content-length";
    public static final String NAME_COOKIE = "cookie";
    public static final String NAME_DATE = "date";
    public static final String NAME_HOST = "host";
    public static final String NAME_HTTP2_SETTINGS = "http2-settings";
    public static final String NAME_LAST_MODIFIED = "last-modified";
    public static final String NAME_LOCATION = "location";
    public static final String NAME_ORIGIN = "origin";
    public static final String NAME_REFERER = "referer";
    public static final String NAME_RETRY_AFTER = "retry-after";
    public static final String NAME_SERVER = "server";
    public static final String NAME_SEC_WEBSOCKET_KEY = "sec-websocket-key";
    public static final String NAME_SEC_WEBSOCKET_EXTENSIONS = "sec-websocket-extensions";
    public static final String NAME_SEC_WEBSOCKET_ACCEPT = "sec-websocket-accept";
    public static final String NAME_SEC_WEBSOCKET_PROTOCOL = "sec-websocket-protocol";
    public static final String NAME_SEC_WEBSOCKET_VERSION = "sec-websocket-version";
    public static final String NAME_SET_COOKIE = "set-cookie";
    public static final String NAME_TE = "te";
    public static final String NAME_TRAILER = "trailer";
    public static final String NAME_TRANSFER_ENCODING = "transfer-encoding";
    public static final String NAME_UPGRADE = "upgrade";
    public static final String NAME_USER_AGENT = "user-agent";
    public static final String NAME_VARY = "www-vary";
    public static final String NAME_WWW_AUTHENTICATE = "www-authenticate";
    public static final String NAME_PSEUDO_AUTHORITY = ":authority";
    public static final String NAME_PSEUDO_METHOD = ":method";
    public static final String NAME_PSEUDO_PATH = ":path";
    public static final String NAME_PSEUDO_SCHEME = ":scheme";
    public static final String NAME_PSEUDO_STATUS = ":status";
    public static final String VALUE_100_CONTINUE = "100-continue";
    public static final String VALUE_CHUNKED = "chunked";
    public static final String VALUE_CLOSE = "close";
    public static final String VALUE_DEFLATE = "deflate";
    public static final String VALUE_GZIP = "gzip";
    public static final String VALUE_TRAILERS = "trailers";
    public static final String VALUE_UPGRADE_H2C = "h2c";
    public static final String VALUE_WEBSOCKET = "websocket";
    public static final String VALUE_X_DEFLATE = "x-deflate";
    public static final String VALUE_X_GZIP = "x-gzip";

    private Headers() {
    }

    public static interface AcceptLanguage
    extends Header {
        public static final AcceptLanguage ALL = new AcceptLanguageCodec.AcceptLanguage(null);

        public List<LanguageRange> getLanguageRanges();

        default public Optional<AcceptMatch<LanguageRange, LanguageRange>> findBestMatch(Collection<LanguageRange> languageRanges) {
            return this.findBestMatch(languageRanges, Function.identity());
        }

        default public <T> Optional<AcceptMatch<LanguageRange, T>> findBestMatch(Collection<T> items, Function<T, LanguageRange> languageRangeExtractor) {
            return this.findAllMatch(items, languageRangeExtractor).stream().findFirst();
        }

        default public Collection<AcceptMatch<LanguageRange, LanguageRange>> findAllMatch(Collection<LanguageRange> languageRanges) {
            return this.findAllMatch(languageRanges, Function.identity());
        }

        default public <T> Collection<AcceptMatch<LanguageRange, T>> findAllMatch(Collection<T> items, Function<T, LanguageRange> languageRangeExtractor) {
            return this.getLanguageRanges().stream().flatMap(languageRange -> items.stream().map(item -> {
                LanguageRange itemLanguageRange = (LanguageRange)languageRangeExtractor.apply(item);
                if (languageRange.matches(itemLanguageRange)) {
                    int score = languageRange.getLanguageTag().equals(itemLanguageRange.getLanguageTag()) ? 100000 + itemLanguageRange.getScore() : 10000 + itemLanguageRange.getScore();
                    return new AcceptLanguageMatch<LanguageRange, Object>((LanguageRange)languageRange, item, score);
                }
                return null;
            }).filter(Objects::nonNull)).sorted((o1, o2) -> o2.getScore() - o1.getScore()).collect(Collectors.toList());
        }

        public static Optional<AcceptLanguage> merge(final List<AcceptLanguage> acceptLanguageHeaders) {
            if (acceptLanguageHeaders.isEmpty()) {
                return Optional.empty();
            }
            if (acceptLanguageHeaders.size() == 1) {
                return Optional.of(acceptLanguageHeaders.get(0));
            }
            return Optional.of(new AcceptLanguage(){

                @Override
                public String getHeaderName() {
                    return Headers.NAME_ACCEPT_LANGUAGE;
                }

                @Override
                public String getHeaderValue() {
                    return acceptLanguageHeaders.stream().map(Header::getHeaderValue).collect(Collectors.joining(", "));
                }

                @Override
                public List<LanguageRange> getLanguageRanges() {
                    return acceptLanguageHeaders.stream().flatMap(accept -> accept.getLanguageRanges().stream()).distinct().sorted(LanguageRange.COMPARATOR).collect(Collectors.toList());
                }
            });
        }

        public static interface LanguageRange {
            public static final Comparator<LanguageRange> COMPARATOR = (r1, r2) -> r2.getScore() - r1.getScore();

            public String getLanguageTag();

            public String getPrimarySubTag();

            public String getSecondarySubTag();

            public float getWeight();

            default public boolean matches(LanguageRange languageRange) {
                String requestPrimarySubTag = languageRange.getPrimarySubTag();
                String requestSecondarySubTag = languageRange.getSecondarySubTag();
                String primarySubType = this.getPrimarySubTag();
                String secondarySubType = this.getSecondarySubTag();
                if (requestPrimarySubTag.equals("*")) {
                    return true;
                }
                if (requestSecondarySubTag == null) {
                    return primarySubType.equals("*") || primarySubType.equals(requestPrimarySubTag);
                }
                return !(!primarySubType.equals("*") && !primarySubType.equals(requestPrimarySubTag) || secondarySubType != null && !secondarySubType.equals(requestSecondarySubTag));
            }

            default public int getScore() {
                String primarySubTag = this.getPrimarySubTag();
                String secondarySubTag = this.getSecondarySubTag();
                float weight = this.getWeight();
                int score = 0;
                score = (int)((float)score + 1000.0f * weight);
                if (!primarySubTag.equals("*")) {
                    score = secondarySubTag == null ? (score += 10) : (score += 20);
                }
                return score;
            }

            public static Optional<AcceptMatch<LanguageRange, LanguageRange>> findFirstMatch(LanguageRange languageRange, List<LanguageRange> languageRanges) {
                return LanguageRange.findFirstMatch(languageRange, languageRanges, Function.identity());
            }

            public static <T> Optional<AcceptMatch<T, LanguageRange>> findFirstMatch(LanguageRange languageRange, Collection<T> items, Function<T, LanguageRange> languageRangeExtractor) {
                String requestPrimarySubTag = languageRange.getPrimarySubTag();
                String requestSecondarySubTag = languageRange.getSecondarySubTag();
                return items.stream().filter(item -> {
                    LanguageRange range = (LanguageRange)languageRangeExtractor.apply(item);
                    String primarySubType = range.getPrimarySubTag();
                    String secondarySubType = range.getSecondarySubTag();
                    if (requestPrimarySubTag.equals("*")) {
                        return true;
                    }
                    if (requestSecondarySubTag == null) {
                        return primarySubType.equals("*") || primarySubType.equals(requestPrimarySubTag);
                    }
                    return !(!primarySubType.equals("*") && !primarySubType.equals(requestPrimarySubTag) || !secondarySubType.equals("*") && !secondarySubType.equals(requestSecondarySubTag));
                }).findFirst().map(item -> new AcceptMatch<Object, LanguageRange>(item, languageRange));
            }
        }
    }

    private static class AcceptLanguageMatch<A, B>
    extends AcceptMatch<A, B> {
        private final int score;

        private AcceptLanguageMatch(A source, B target, int score) {
            super(source, target);
            this.score = score;
        }

        public int getScore() {
            return this.score;
        }
    }

    public static class AcceptMatch<A, B> {
        private final A source;
        private final B target;

        private AcceptMatch(A source, B target) {
            this.source = source;
            this.target = target;
        }

        public A getSource() {
            return this.source;
        }

        public B getTarget() {
            return this.target;
        }
    }

    public static interface Accept
    extends Header {
        public static final Accept ALL = new AcceptCodec.Accept(null);

        public List<MediaRange> getMediaRanges();

        default public Optional<AcceptMatch<MediaRange, ContentType>> findBestMatch(Collection<ContentType> contentTypes) {
            return this.findBestMatch(contentTypes, Function.identity());
        }

        default public <T> Optional<AcceptMatch<MediaRange, T>> findBestMatch(Collection<T> items, Function<T, ContentType> contentTypeExtractor) {
            for (MediaRange mediaRange : this.getMediaRanges()) {
                for (T item : items) {
                    if (!mediaRange.matches(contentTypeExtractor.apply(item))) continue;
                    return Optional.of(new AcceptMatch<MediaRange, T>(mediaRange, item));
                }
            }
            return Optional.empty();
        }

        default public Collection<AcceptMatch<MediaRange, ContentType>> findAllMatch(Collection<ContentType> contentTypes) {
            return this.findAllMatch(contentTypes, Function.identity());
        }

        default public <T> Collection<AcceptMatch<MediaRange, T>> findAllMatch(Collection<T> items, Function<T, ContentType> contentTypeExtractor) {
            ArrayList<AcceptMatch<MediaRange, T>> result = new ArrayList<AcceptMatch<MediaRange, T>>();
            for (MediaRange mediaRange : this.getMediaRanges()) {
                for (T item : items) {
                    if (!mediaRange.matches(contentTypeExtractor.apply(item))) continue;
                    result.add(new AcceptMatch<MediaRange, T>(mediaRange, item));
                }
            }
            return result;
        }

        public static Optional<Accept> merge(final List<Accept> acceptHeaders) {
            if (acceptHeaders == null || acceptHeaders.isEmpty()) {
                return Optional.empty();
            }
            if (acceptHeaders.size() == 1) {
                return Optional.of(acceptHeaders.get(0));
            }
            return Optional.of(new Accept(){

                @Override
                public String getHeaderName() {
                    return Headers.NAME_ACCEPT;
                }

                @Override
                public String getHeaderValue() {
                    return acceptHeaders.stream().map(Header::getHeaderValue).collect(Collectors.joining(", "));
                }

                @Override
                public List<MediaRange> getMediaRanges() {
                    return acceptHeaders.stream().flatMap(accept -> accept.getMediaRanges().stream()).distinct().sorted(MediaRange.COMPARATOR).collect(Collectors.toList());
                }
            });
        }

        public static interface MediaRange {
            public static final Comparator<MediaRange> COMPARATOR = (r1, r2) -> r2.getScore() - r1.getScore();

            public String getMediaType();

            public String getType();

            public String getSubType();

            public float getWeight();

            public Map<String, String> getParameters();

            default public boolean matches(ContentType contentType) {
                String requestType = contentType.getType();
                String requestSubType = contentType.getSubType();
                Map<String, String> requestParameters = contentType.getParameters();
                String consumeType = this.getType();
                String consumeSubType = this.getSubType();
                Map<String, String> consumeParameters = this.getParameters();
                if (requestType.equals("*")) {
                    if (requestSubType.equals("*")) {
                        return consumeParameters.isEmpty() || consumeParameters.equals(requestParameters);
                    }
                    return !(!consumeSubType.equals("*") && !consumeSubType.equals(requestSubType) || !consumeParameters.isEmpty() && !consumeParameters.equals(requestParameters));
                }
                if (requestSubType.equals("*")) {
                    return !(!consumeType.equals("*") && !consumeType.equals(requestType) || !consumeParameters.isEmpty() && !consumeParameters.equals(requestParameters));
                }
                return !(!consumeType.equals("*") && !consumeType.equals(requestType) || !consumeSubType.equals("*") && !consumeSubType.equals(requestSubType) || !consumeParameters.isEmpty() && !consumeParameters.equals(requestParameters));
            }

            default public int getScore() {
                String type = this.getType();
                String subType = this.getSubType();
                Map<String, String> parameters = this.getParameters();
                float weight = this.getWeight();
                int score = 0;
                score = (int)((float)score + 1000.0f * weight);
                score = type.equals("*") ? (subType.equals("*") ? (score += 0) : (score += 10)) : (subType.equals("*") ? (score += 20) : (score += 30));
                for (Map.Entry<String, String> e : parameters.entrySet()) {
                    if (e.getValue() == null) {
                        ++score;
                        continue;
                    }
                    score += 2;
                }
                return score;
            }

            public static Optional<AcceptMatch<MediaRange, ContentType>> findFirstMatch(ContentType contentType, List<MediaRange> mediaRanges) {
                return MediaRange.findFirstMatch(contentType, mediaRanges, Function.identity());
            }

            public static <T> Optional<AcceptMatch<T, ContentType>> findFirstMatch(ContentType contentType, Collection<T> items, Function<T, MediaRange> mediaRangeExtractor) {
                String requestType = contentType.getType();
                String requestSubType = contentType.getSubType();
                Map<String, String> requestParameters = contentType.getParameters();
                return items.stream().filter(item -> {
                    MediaRange range = (MediaRange)mediaRangeExtractor.apply(item);
                    String type = range.getType();
                    String subType = range.getSubType();
                    Map<String, String> consumeParameters = range.getParameters();
                    if (requestType.equals("*")) {
                        if (requestSubType.equals("*")) {
                            return consumeParameters.isEmpty() || consumeParameters.equals(requestParameters);
                        }
                        return !(!type.equals("*") && !subType.equals(requestSubType) || !consumeParameters.isEmpty() && !consumeParameters.equals(requestParameters));
                    }
                    if (requestSubType.equals("*")) {
                        return !(!type.equals("*") && !type.equals(requestType) || !consumeParameters.isEmpty() && !consumeParameters.equals(requestParameters));
                    }
                    return !(!type.equals("*") && !type.equals(requestType) || !subType.equals("*") && !subType.equals(requestSubType) || !consumeParameters.isEmpty() && !consumeParameters.equals(requestParameters));
                }).findFirst().map(item -> new AcceptMatch<Object, ContentType>(item, contentType));
            }
        }
    }

    public static interface Cookie
    extends Header {
        public Map<String, List<CookieParameter>> getPairs();
    }

    public static interface SetCookie
    extends Header {
        public static final String EXPIRES = "Expires";
        public static final String MAX_AGE = "Max-Age";
        public static final String DOMAIN = "Domain";
        public static final String PATH = "Path";
        public static final String SECURE = "Secure";
        public static final String HTTPONLY = "HttpOnly";
        public static final String SAME_SITE = "SameSite";

        public String getName();

        public String getValue();

        public ZonedDateTime getExpires();

        public Integer getMaxAge();

        public String getDomain();

        public String getPath();

        public Boolean isSecure();

        public Boolean isHttpOnly();

        public SameSitePolicy getSameSite();

        public static enum SameSitePolicy {
            LAX("Lax"),
            STRICT("Strict"),
            NONE("None");

            private final String value;

            private SameSitePolicy(String value) {
                this.value = value;
            }

            public String getValue() {
                return this.value;
            }

            public static SameSitePolicy fromValue(String value) throws IllegalArgumentException {
                switch (value) {
                    case "Lax": {
                        return LAX;
                    }
                    case "Strict": {
                        return STRICT;
                    }
                    case "None": {
                        return NONE;
                    }
                }
                throw new IllegalArgumentException("Unknown same site policy: " + value);
            }
        }
    }

    public static interface ContentDisposition
    extends Header {
        public static final String PART_NAME = "name";
        public static final String FILENAME = "filename";
        public static final String CREATION_DATE = "creation-date";
        public static final String MODIFICATION_DATE = "modification-date";
        public static final String READ_DATE = "read-date";
        public static final String SIZE = "size";
        public static final String TYPE_FORM_DATA = "form-data";

        public String getDispositionType();

        public String getPartName();

        public String getFilename();

        public String getCreationDateTime();

        public String getModificationDatetime();

        public String getReadDateTime();

        public Integer getSize();
    }

    public static interface Authorization
    extends Header {
        public static final String AUTH_SCHEME_BASIC = "basic";
        public static final String AUTH_SCHEME_BEARER = "bearer";
        public static final String AUTH_SCHEME_DIGEST = "digest";
        public static final String AUTH_SCHEME_NEGOTIATE = "negotiate";

        public String getAuthScheme();

        public Map<String, String> getParameters();

        public String getToken();
    }

    public static interface ContentType
    extends Header {
        public static final String BOUNDARY = "boundary";
        public static final String CHARSET = "charset";

        public String getMediaType();

        public String getType();

        public String getSubType();

        public String getBoundary();

        public Charset getCharset();

        public Map<String, String> getParameters();

        public Accept.MediaRange toMediaRange();
    }

    public static interface SimpleHeader
    extends Header {
    }
}

