/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpVersion;

public class FlatHttpRequest
implements HttpRequest,
HttpContent {
    protected HttpMethod method;
    protected String uri;
    protected HttpVersion version;
    protected HttpHeaders headers;
    protected final ByteBuf content;
    protected DecoderResult result = DecoderResult.SUCCESS;
    private boolean empty;

    public FlatHttpRequest(ByteBuf content) {
        this.content = content;
    }

    public FlatHttpRequest(HttpVersion version, HttpMethod method, String uri, HttpHeaders headers, boolean empty) {
        this(version, method, uri, headers, Unpooled.EMPTY_BUFFER);
        this.empty = empty;
    }

    public FlatHttpRequest(HttpVersion version, HttpMethod method, String uri, HttpHeaders headers, ByteBuf content) {
        this.method = method;
        this.uri = uri;
        this.version = version;
        this.headers = headers;
        this.content = content;
        this.empty = content.readableBytes() == 0;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    @Deprecated
    public HttpMethod getMethod() {
        return this.method;
    }

    public HttpMethod method() {
        return this.method;
    }

    public HttpRequest setMethod(HttpMethod method) {
        this.method = method;
        return this;
    }

    @Deprecated
    public String getUri() {
        return this.uri;
    }

    public String uri() {
        return this.uri;
    }

    public HttpRequest setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public HttpRequest setProtocolVersion(HttpVersion version) {
        this.version = version;
        return this;
    }

    @Deprecated
    public HttpVersion getProtocolVersion() {
        return this.version;
    }

    public HttpVersion protocolVersion() {
        return this.version;
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    @Deprecated
    public DecoderResult getDecoderResult() {
        return this.result;
    }

    public DecoderResult decoderResult() {
        return this.result;
    }

    public void setDecoderResult(DecoderResult result) {
        this.result = result;
    }

    public ByteBuf content() {
        return this.content;
    }

    public int refCnt() {
        return this.content.refCnt();
    }

    public boolean release() {
        return this.content.release();
    }

    public boolean release(int decrement) {
        return this.content.release(decrement);
    }

    public FlatHttpRequest copy() {
        return this.replace(this.content.copy());
    }

    public FlatHttpRequest duplicate() {
        return this.replace(this.content.duplicate());
    }

    public FlatHttpRequest retainedDuplicate() {
        return this.replace(this.content.retainedDuplicate());
    }

    public FlatHttpRequest replace(ByteBuf content) {
        return new FlatHttpRequest(this.version, this.method, this.uri, this.headers.copy(), content);
    }

    public FlatHttpRequest retain() {
        this.content.retain();
        return this;
    }

    public FlatHttpRequest retain(int increment) {
        this.content.retain(increment);
        return this;
    }

    public FlatHttpRequest touch() {
        this.content.touch();
        return this;
    }

    public FlatHttpRequest touch(Object hint) {
        this.content.touch(hint);
        return this;
    }
}

