/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.ws;

import io.inverno.mod.http.base.ExchangeContext;
import io.inverno.mod.http.base.ws.WebSocketFrame;
import io.inverno.mod.http.base.ws.WebSocketMessage;
import io.inverno.mod.http.base.ws.WebSocketStatus;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public interface BaseWebSocketExchange<A extends ExchangeContext> {
    public A context();

    public String getSubProtocol();

    public Inbound inbound();

    public Outbound outbound();

    default public void close() {
        this.close(WebSocketStatus.NORMAL_CLOSURE, WebSocketStatus.NORMAL_CLOSURE.getReason());
    }

    default public void close(WebSocketStatus status) {
        this.close(status.getCode(), status.getReason());
    }

    default public void close(short code) {
        this.close(code, null);
    }

    default public void close(String reason) {
        this.close(WebSocketStatus.NORMAL_CLOSURE.getCode(), reason);
    }

    default public void close(WebSocketStatus status, String reason) {
        this.close(status.getCode(), reason);
    }

    public void close(short var1, String var2);

    public BaseWebSocketExchange<A> finalizer(Mono<Void> var1);

    public static interface Outbound {
        public Outbound closeOnComplete(boolean var1);

        public void frames(Function<WebSocketFrame.Factory, Publisher<WebSocketFrame>> var1);

        public void messages(Function<WebSocketMessage.Factory, Publisher<WebSocketMessage>> var1);
    }

    public static interface Inbound {
        public Publisher<WebSocketFrame> frames();

        public Publisher<WebSocketMessage> messages();

        public Publisher<WebSocketMessage> textMessages();

        public Publisher<WebSocketMessage> binaryMessages();
    }
}

