/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.header;

import io.inverno.mod.http.base.header.AbstractHeaderBuilder;
import io.inverno.mod.http.base.internal.header.GenericHeader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class ParameterizedHeader
extends GenericHeader {
    protected Map<String, String> parameters;
    protected String parameterizedValue;

    protected ParameterizedHeader(String headerName, String headerValue, String parameterizedValue, Map<String, String> parameters) {
        super(headerName, headerValue);
        this.parameters = parameters != null ? new HashMap<String, String>(parameters) : new HashMap();
        this.parameterizedValue = parameterizedValue;
    }

    public String getParameterizedValue() {
        return this.parameterizedValue;
    }

    public Map<String, String> getParameters() {
        if (this.parameters != null) {
            return Collections.unmodifiableMap(this.parameters);
        }
        return Map.of();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.parameterizedValue == null ? 0 : this.parameterizedValue.hashCode());
        result = 31 * result + (this.parameters == null ? 0 : this.parameters.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParameterizedHeader other = (ParameterizedHeader)obj;
        if (this.parameterizedValue == null ? other.parameterizedValue != null : !this.parameterizedValue.equals(other.parameterizedValue)) {
            return false;
        }
        return !(this.parameters == null ? other.parameters != null : !this.parameters.equals(other.parameters));
    }

    public static class Builder
    extends AbstractBuilder<ParameterizedHeader, Builder> {
        @Override
        public ParameterizedHeader build() {
            return new ParameterizedHeader(this.headerName, this.headerValue, this.parameterizedValue, this.parameters);
        }
    }

    public static abstract class AbstractBuilder<A extends ParameterizedHeader, B extends AbstractBuilder<A, B>>
    extends AbstractHeaderBuilder<A, B> {
        protected String parameterizedValue;
        protected Map<String, String> parameters;

        public B parameterizedValue(String parameterizedValue) {
            this.parameterizedValue = parameterizedValue;
            return (B)this;
        }

        public B parameter(String name, String value) {
            if (this.parameters == null) {
                this.parameters = new LinkedHashMap<String, String>();
            }
            this.parameters.put(name, value);
            return (B)this;
        }
    }
}

