/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.header;

import io.inverno.core.annotation.Bean;
import io.inverno.mod.http.base.UnsupportedMediaTypeException;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.internal.header.AcceptCodec;
import io.inverno.mod.http.base.internal.header.ParameterizedHeader;
import io.inverno.mod.http.base.internal.header.ParameterizedHeaderCodec;
import io.netty.util.internal.PlatformDependent;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class ContentTypeCodec
extends ParameterizedHeaderCodec<ContentType, ContentType.Builder> {
    private static final String BOUNDARY_PADDING = "------------------------";

    public ContentTypeCodec() {
        super(ContentType.Builder::new, Set.of("content-type"), ';', ';', ',', false, false, false, false, true, false);
    }

    @Override
    public String encodeValue(ContentType headerField) {
        StringBuilder result = new StringBuilder();
        result.append(headerField.getParameterizedValue());
        HashMap<String, String> parameters = new HashMap<String, String>(headerField.getParameters());
        if (headerField.boundary != null) {
            parameters.put("boundary", headerField.boundary);
        }
        if (headerField.charset != null) {
            parameters.put("charset", headerField.charset.toString());
        }
        if (!parameters.isEmpty()) {
            parameters.entrySet().stream().forEach(e -> result.append(this.parameterDelimiter).append((String)e.getKey()).append("=").append((String)e.getValue()));
        }
        return result.toString();
    }

    public static String generateMultipartBoundary() {
        return BOUNDARY_PADDING + Long.toHexString(PlatformDependent.threadLocalRandom().nextLong());
    }

    public static final class ContentType
    extends ParameterizedHeader
    implements Headers.ContentType {
        private String mediaType;
        private String type;
        private String subType;
        private String boundary;
        private Charset charset;

        public ContentType(String mediaType, Charset charset, String boundary, Map<String, String> parameters) {
            super("content-type", null, mediaType, parameters);
            this.setMediaType(mediaType.toLowerCase());
            this.setCharset(charset);
            this.setBoundary(boundary);
        }

        private ContentType(String headerValue, String parameterizedValue, Map<String, String> parameters, String boundary, Charset charset) {
            super("content-type", headerValue, parameterizedValue, parameters);
            this.setMediaType(parameterizedValue.toLowerCase());
            this.boundary = boundary;
            this.charset = charset;
        }

        @Override
        public String getMediaType() {
            return this.mediaType;
        }

        private void setMediaType(String mediaType) {
            this.mediaType = mediaType;
            this.parameterizedValue = mediaType;
            String[] splitMediaType = mediaType.split("/");
            if (splitMediaType.length != 2) {
                throw new UnsupportedMediaTypeException("Invalid content type");
            }
            this.setType(splitMediaType[0]);
            this.setSubType(splitMediaType[1]);
            if (!HeaderService.isToken(this.type) || !HeaderService.isToken(this.subType)) {
                throw new UnsupportedMediaTypeException("Invalid content type");
            }
        }

        @Override
        public String getType() {
            return this.type;
        }

        private void setType(String type) {
            if (!HeaderService.isToken(type)) {
                throw new UnsupportedMediaTypeException("Invalid content type");
            }
            this.type = type;
        }

        @Override
        public String getSubType() {
            return this.subType;
        }

        private void setSubType(String subType) {
            if (!HeaderService.isToken(subType)) {
                throw new UnsupportedMediaTypeException("Invalid content type");
            }
            this.subType = subType;
        }

        @Override
        public String getBoundary() {
            return this.boundary;
        }

        private void setBoundary(String boundary) {
            this.boundary = boundary;
            if (boundary != null) {
                this.parameters.put("boundary", this.charset.toString());
            } else {
                this.parameters.remove("boundary");
            }
        }

        @Override
        public Charset getCharset() {
            return this.charset;
        }

        private void setCharset(Charset charset) {
            this.charset = charset;
            if (charset != null) {
                this.parameters.put("charset", charset.toString());
            } else {
                this.parameters.remove("charset");
            }
        }

        @Override
        public Headers.Accept.MediaRange toMediaRange() {
            return new AcceptCodec.Accept.MediaRange(this.type, this.subType, 1.0f, this.parameters);
        }

        public static final class Builder
        extends ParameterizedHeader.AbstractBuilder<ContentType, Builder> {
            private String boundary;
            private Charset charset;

            @Override
            public Builder parameter(String name, String value) {
                if (name.equalsIgnoreCase("boundary")) {
                    this.boundary = value;
                } else if (name.equalsIgnoreCase("charset")) {
                    this.charset = Charset.forName(value);
                }
                return (Builder)super.parameter(name, value);
            }

            @Override
            public ContentType build() {
                return new ContentType(this.headerValue, this.parameterizedValue, this.parameters, this.boundary, this.charset);
            }
        }
    }
}

