/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal;

import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.Parameter;
import java.io.File;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.util.Currency;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;

public class GenericParameter
implements Parameter {
    protected final ObjectConverter<String> parameterConverter;
    protected final String name;
    protected final String value;

    public GenericParameter(String name, String value, ObjectConverter<String> parameterConverter) {
        this.parameterConverter = parameterConverter;
        this.name = name;
        this.value = value;
    }

    public GenericParameter(String name, Object value, ObjectConverter<String> parameterConverter) {
        this.parameterConverter = parameterConverter;
        this.name = name;
        this.value = (String)parameterConverter.encode(value);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public <T> T as(Class<T> type) {
        return (T)this.parameterConverter.decode((Object)this.value, type);
    }

    public <T> T as(Type type) {
        return (T)this.parameterConverter.decode((Object)this.value, type);
    }

    public <T> T[] asArrayOf(Class<T> type) {
        return this.parameterConverter.decodeToArray((Object)this.value, type);
    }

    public <T> T[] asArrayOf(Type type) {
        return this.parameterConverter.decodeToArray((Object)this.value, type);
    }

    public <T> List<T> asListOf(Class<T> type) {
        return this.parameterConverter.decodeToList((Object)this.value, type);
    }

    public <T> List<T> asListOf(Type type) {
        return this.parameterConverter.decodeToList((Object)this.value, type);
    }

    public <T> Set<T> asSetOf(Class<T> type) {
        return this.parameterConverter.decodeToSet((Object)this.value, type);
    }

    public <T> Set<T> asSetOf(Type type) {
        return this.parameterConverter.decodeToSet((Object)this.value, type);
    }

    public Byte asByte() {
        return this.parameterConverter.decodeByte((Object)this.value);
    }

    public Short asShort() {
        return this.parameterConverter.decodeShort((Object)this.value);
    }

    public Integer asInteger() {
        return this.parameterConverter.decodeInteger((Object)this.value);
    }

    public Long asLong() {
        return this.parameterConverter.decodeLong((Object)this.value);
    }

    public Float asFloat() {
        return this.parameterConverter.decodeFloat((Object)this.value);
    }

    public Double asDouble() {
        return this.parameterConverter.decodeDouble((Object)this.value);
    }

    public Character asCharacter() {
        return this.parameterConverter.decodeCharacter((Object)this.value);
    }

    public String asString() {
        return this.parameterConverter.decodeString((Object)this.value);
    }

    public Boolean asBoolean() {
        return this.parameterConverter.decodeBoolean((Object)this.value);
    }

    public BigInteger asBigInteger() {
        return this.parameterConverter.decodeBigInteger((Object)this.value);
    }

    public BigDecimal asBigDecimal() {
        return this.parameterConverter.decodeBigDecimal((Object)this.value);
    }

    public LocalDate asLocalDate() {
        return this.parameterConverter.decodeLocalDate((Object)this.value);
    }

    public LocalDateTime asLocalDateTime() {
        return this.parameterConverter.decodeLocalDateTime((Object)this.value);
    }

    public ZonedDateTime asZonedDateTime() {
        return this.parameterConverter.decodeZonedDateTime((Object)this.value);
    }

    public Currency asCurrency() {
        return this.parameterConverter.decodeCurrency((Object)this.value);
    }

    public Locale asLocale() {
        return this.parameterConverter.decodeLocale((Object)this.value);
    }

    public File asFile() {
        return this.parameterConverter.decodeFile((Object)this.value);
    }

    public Path asPath() {
        return this.parameterConverter.decodePath((Object)this.value);
    }

    public URI asURI() {
        return this.parameterConverter.decodeURI((Object)this.value);
    }

    public URL asURL() {
        return this.parameterConverter.decodeURL((Object)this.value);
    }

    public Pattern asPattern() {
        return this.parameterConverter.decodePattern((Object)this.value);
    }

    public InetAddress asInetAddress() {
        return this.parameterConverter.decodeInetAddress((Object)this.value);
    }

    public Class<?> asClass() {
        return this.parameterConverter.decodeClass((Object)this.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GenericParameter other = (GenericParameter)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }
}

