/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.ws;

import io.inverno.mod.http.base.Status;
import io.inverno.mod.http.base.ws.WebSocketException;
import java.util.Optional;
import java.util.Set;

public class UnsupportedProtocolException
extends WebSocketException {
    private static final long serialVersionUID = 1L;
    private final Optional<Set<String>> supportedProtocols;

    public UnsupportedProtocolException() {
        super(Status.BAD_REQUEST);
        this.supportedProtocols = Optional.empty();
    }

    public UnsupportedProtocolException(String message) {
        super(Status.BAD_REQUEST, message);
        this.supportedProtocols = Optional.empty();
    }

    public UnsupportedProtocolException(Throwable cause) {
        super(Status.BAD_REQUEST, cause);
        this.supportedProtocols = Optional.empty();
    }

    public UnsupportedProtocolException(String message, Throwable cause) {
        super(Status.BAD_REQUEST, message, cause);
        this.supportedProtocols = Optional.empty();
    }

    public UnsupportedProtocolException(Set<String> supportedProtocols) {
        super(Status.BAD_REQUEST);
        this.supportedProtocols = Optional.ofNullable(supportedProtocols);
    }

    public UnsupportedProtocolException(Set<String> supportedProtocols, String message) {
        super(Status.BAD_REQUEST, message);
        this.supportedProtocols = Optional.ofNullable(supportedProtocols);
    }

    public UnsupportedProtocolException(Set<String> supportedProtocols, Throwable cause) {
        super(Status.BAD_REQUEST, cause);
        this.supportedProtocols = Optional.ofNullable(supportedProtocols);
    }

    public UnsupportedProtocolException(Set<String> supportedProtocols, String message, Throwable cause) {
        super(Status.BAD_REQUEST, message, cause);
        this.supportedProtocols = Optional.ofNullable(supportedProtocols);
    }

    public Optional<Set<String>> getSupportedProtocol() {
        return this.supportedProtocols;
    }
}

