/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;

public class FlatHttpResponse
implements HttpResponse,
HttpContent {
    protected HttpVersion version;
    protected HttpResponseStatus status;
    protected HttpHeaders headers;
    protected final ByteBuf content;
    protected DecoderResult result = DecoderResult.SUCCESS;
    private boolean empty;

    public FlatHttpResponse(HttpVersion version, HttpResponseStatus status, HttpHeaders headers, boolean empty) {
        this(version, status, headers, Unpooled.EMPTY_BUFFER);
        this.empty = empty;
    }

    public FlatHttpResponse(HttpVersion version, HttpResponseStatus status, HttpHeaders headers, ByteBuf content) {
        this.status = status;
        this.version = version;
        this.headers = headers;
        this.content = content;
        this.empty = content.readableBytes() == 0;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    @Deprecated
    public HttpVersion getProtocolVersion() {
        return this.version;
    }

    public HttpVersion protocolVersion() {
        return this.version;
    }

    public HttpHeaders headers() {
        return this.headers;
    }

    @Deprecated
    public DecoderResult getDecoderResult() {
        return this.result;
    }

    public DecoderResult decoderResult() {
        return this.result;
    }

    public void setDecoderResult(DecoderResult result) {
        this.result = result;
    }

    public ByteBuf content() {
        return this.content;
    }

    public int refCnt() {
        return this.content.refCnt();
    }

    public boolean release() {
        return this.content.release();
    }

    public boolean release(int decrement) {
        return this.content.release(decrement);
    }

    public FlatHttpResponse copy() {
        return this.replace(this.content.copy());
    }

    public FlatHttpResponse duplicate() {
        return this.replace(this.content.duplicate());
    }

    public FlatHttpResponse retainedDuplicate() {
        return this.replace(this.content.retainedDuplicate());
    }

    public FlatHttpResponse replace(ByteBuf content) {
        return new FlatHttpResponse(this.version, this.status, this.headers.copy(), content);
    }

    public FlatHttpResponse retain() {
        this.content.retain();
        return this;
    }

    public FlatHttpResponse retain(int increment) {
        this.content.retain(increment);
        return this;
    }

    public FlatHttpResponse touch() {
        this.content.touch();
        return this;
    }

    public FlatHttpResponse touch(Object hint) {
        this.content.touch(hint);
        return this;
    }

    @Deprecated
    public HttpResponseStatus getStatus() {
        return this.status;
    }

    public HttpResponseStatus status() {
        return this.status;
    }

    public FlatHttpResponse setStatus(HttpResponseStatus status) {
        this.status = status;
        return this;
    }

    public FlatHttpResponse setProtocolVersion(HttpVersion version) {
        this.version = version;
        return this;
    }
}

