/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base;

import io.inverno.mod.http.base.HttpException;
import io.inverno.mod.http.base.Status;
import java.util.Optional;
import java.util.Set;

public class NotAcceptableException
extends HttpException {
    private static final long serialVersionUID = 7410917159887462383L;
    private final Optional<Set<String>> acceptableMediaTypes;

    public NotAcceptableException() {
        super(Status.NOT_ACCEPTABLE);
        this.acceptableMediaTypes = Optional.empty();
    }

    public NotAcceptableException(String message) {
        super(Status.NOT_ACCEPTABLE, message);
        this.acceptableMediaTypes = Optional.empty();
    }

    public NotAcceptableException(Throwable cause) {
        super(Status.NOT_ACCEPTABLE, cause);
        this.acceptableMediaTypes = Optional.empty();
    }

    public NotAcceptableException(String message, Throwable cause) {
        super(Status.NOT_ACCEPTABLE, message, cause);
        this.acceptableMediaTypes = Optional.empty();
    }

    public NotAcceptableException(Set<String> acceptableMediaTypes) {
        super(Status.NOT_ACCEPTABLE);
        this.acceptableMediaTypes = Optional.ofNullable(acceptableMediaTypes);
    }

    public NotAcceptableException(Set<String> acceptableMediaTypes, String message) {
        super(Status.NOT_ACCEPTABLE, message);
        this.acceptableMediaTypes = Optional.ofNullable(acceptableMediaTypes);
    }

    public NotAcceptableException(Set<String> acceptableMediaTypes, Throwable cause) {
        super(Status.NOT_ACCEPTABLE, cause);
        this.acceptableMediaTypes = Optional.ofNullable(acceptableMediaTypes);
    }

    public NotAcceptableException(Set<String> acceptableMediaTypes, String message, Throwable cause) {
        super(Status.NOT_ACCEPTABLE, message, cause);
        this.acceptableMediaTypes = Optional.ofNullable(acceptableMediaTypes);
    }

    public Optional<Set<String>> getAcceptableMediaTypes() {
        return this.acceptableMediaTypes;
    }
}

