/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.ws;

public enum WebSocketStatus {
    NORMAL_CLOSURE(1000, "Normal Closure"),
    ENDPOINT_UNAVAILABLE(1001, "Going Away"),
    PROTOCOL_ERROR(1002, "Protocol Error"),
    UNSUPPORTED_DATA(1003, "Unsupported Data"),
    NO_STATUS(1005, "No Status"),
    CLOSED_ABNORMALLY(1006, "Closed Abnormally"),
    INVALID_PAYLOAD_DATA(1007, "Invalid Payload Data"),
    POLICY_VIOLATION(1008, "Policy Violation"),
    MESSAGE_TOO_BIG(1009, "Message Too Big"),
    MANDATORY_EXTENSION(1010, "Mandatory Extension"),
    INTERNAL_SERVER_ERROR(1011, "Internal Server Error"),
    SERVICE_RESTART(1012, "Service Restart"),
    TRY_AGAIN_LATER(1013, "Try Again Later"),
    BAD_GATEWAY(1014, "Bad Gateway"),
    TLS_HANDSHAKE_ERROR(1015, "TLS Handshake Error");

    private final short code;
    private final String reason;

    private WebSocketStatus(short code, String reason) {
        this.code = code;
        this.reason = reason;
    }

    public short getCode() {
        return this.code;
    }

    public String getReason() {
        return this.reason;
    }

    public static WebSocketStatus valueOf(short code) {
        switch (code) {
            case 1000: {
                return NORMAL_CLOSURE;
            }
            case 1001: {
                return ENDPOINT_UNAVAILABLE;
            }
            case 1002: {
                return PROTOCOL_ERROR;
            }
            case 1003: {
                return UNSUPPORTED_DATA;
            }
            case 1005: {
                return NO_STATUS;
            }
            case 1006: {
                return CLOSED_ABNORMALLY;
            }
            case 1007: {
                return INVALID_PAYLOAD_DATA;
            }
            case 1008: {
                return POLICY_VIOLATION;
            }
            case 1009: {
                return MESSAGE_TOO_BIG;
            }
            case 1010: {
                return MANDATORY_EXTENSION;
            }
            case 1011: {
                return INTERNAL_SERVER_ERROR;
            }
            case 1015: {
                return TLS_HANDSHAKE_ERROR;
            }
        }
        throw new IllegalArgumentException("No enum constant for status code: " + code);
    }
}

