/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.header;

import io.inverno.core.annotation.Bean;
import io.inverno.core.annotation.BeanSocket;
import io.inverno.mod.http.base.NotAcceptableException;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.internal.header.ParameterizedHeader;
import io.inverno.mod.http.base.internal.header.ParameterizedHeaderCodec;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class AcceptLanguageCodec
extends ParameterizedHeaderCodec<AcceptLanguage, AcceptLanguage.Builder> {
    @BeanSocket
    public AcceptLanguageCodec() {
        this(true);
    }

    public AcceptLanguageCodec(boolean allowMultiple) {
        super(AcceptLanguage.Builder::new, Set.of("accept-language"), ';', ';', ',', false, false, false, false, true, allowMultiple);
    }

    @Override
    public String encodeValue(AcceptLanguage headerField) {
        return headerField.getLanguageRanges().stream().map(range -> {
            StringBuilder result = new StringBuilder();
            result.append(range.getLanguageTag());
            result.append(";q=").append(String.format("%.3f", Float.valueOf(range.getWeight())));
            return result.toString();
        }).collect(Collectors.joining(Character.toString(this.parameterValueDelimiter)));
    }

    public static final class AcceptLanguage
    extends ParameterizedHeader
    implements Headers.AcceptLanguage {
        private List<Headers.AcceptLanguage.LanguageRange> ranges;

        public AcceptLanguage(List<Headers.AcceptLanguage.LanguageRange> ranges) {
            super("accept-language", null, null, null);
            this.ranges = ranges != null && !ranges.isEmpty() ? ranges.stream().sorted(Headers.AcceptLanguage.LanguageRange.COMPARATOR).collect(Collectors.toList()) : List.of(new LanguageRange("*", 1.0f));
        }

        private AcceptLanguage(String headerValue, List<Headers.AcceptLanguage.LanguageRange> ranges) {
            super("accept-language", headerValue, null, null);
            this.ranges = ranges != null && !ranges.isEmpty() ? ranges.stream().sorted(Headers.AcceptLanguage.LanguageRange.COMPARATOR).collect(Collectors.toList()) : List.of(new LanguageRange("*", 1.0f));
        }

        @Override
        public List<Headers.AcceptLanguage.LanguageRange> getLanguageRanges() {
            return this.ranges;
        }

        public static final class LanguageRange
        implements Headers.AcceptLanguage.LanguageRange {
            private final String languageTag;
            private final float weight;
            private final int score;
            private String primarySubTag;
            private String secondarySubTag;

            public LanguageRange(String languageTag, float weight) {
                this.languageTag = languageTag;
                this.weight = weight;
                String[] splitLanguageTag = this.languageTag.split("-");
                if (splitLanguageTag.length == 2) {
                    this.setPrimarySubTag(splitLanguageTag[0]);
                    this.setSecondarySubTag(splitLanguageTag[1]);
                } else if (splitLanguageTag.length == 1) {
                    this.setPrimarySubTag(splitLanguageTag[0]);
                } else {
                    throw new NotAcceptableException("Empty language tag");
                }
                this.score = Headers.AcceptLanguage.LanguageRange.super.getScore();
            }

            @Override
            public String getLanguageTag() {
                return this.languageTag;
            }

            @Override
            public String getPrimarySubTag() {
                return this.primarySubTag;
            }

            private void setPrimarySubTag(String primarySubTag) {
                if (!primarySubTag.equals("*")) {
                    int size = 0;
                    for (byte b : primarySubTag.getBytes()) {
                        size = (byte)(size + 1);
                        if ((b >= 65 && b <= 90 || b >= 97 && b <= 122) && size <= 8) continue;
                        throw new NotAcceptableException("Invalid language tag");
                    }
                    if (size == 0) {
                        throw new NotAcceptableException("Invalid language tag");
                    }
                }
                this.primarySubTag = primarySubTag;
            }

            @Override
            public String getSecondarySubTag() {
                return this.secondarySubTag;
            }

            private void setSecondarySubTag(String secondarySubTag) {
                if (this.primarySubTag.equals("*")) {
                    throw new NotAcceptableException("Invalid language tag");
                }
                int size = 0;
                for (byte b : secondarySubTag.getBytes()) {
                    size = (byte)(size + 1);
                    if ((b >= 65 && b <= 90 || b >= 97 && b <= 122 || Character.isDigit(b)) && size <= 8) continue;
                    throw new NotAcceptableException("Invalid language tag: " + this.languageTag);
                }
                if (size == 0) {
                    throw new NotAcceptableException("Invalid language tag");
                }
                this.secondarySubTag = secondarySubTag;
            }

            @Override
            public float getWeight() {
                return this.weight;
            }

            @Override
            public int getScore() {
                return this.score;
            }

            public int hashCode() {
                int prime = 31;
                int result = 1;
                result = 31 * result + (this.languageTag == null ? 0 : this.languageTag.hashCode());
                result = 31 * result + Float.floatToIntBits(this.weight);
                return result;
            }

            public boolean equals(Object obj) {
                if (this == obj) {
                    return true;
                }
                if (obj == null) {
                    return false;
                }
                if (this.getClass() != obj.getClass()) {
                    return false;
                }
                LanguageRange other = (LanguageRange)obj;
                if (this.languageTag == null ? other.languageTag != null : !this.languageTag.equals(other.languageTag)) {
                    return false;
                }
                return Float.floatToIntBits(this.weight) == Float.floatToIntBits(other.weight);
            }
        }

        public static final class Builder
        extends ParameterizedHeader.AbstractBuilder<AcceptLanguage, Builder> {
            private List<Headers.AcceptLanguage.LanguageRange> ranges;
            private float weight = 1.0f;

            private void addCurrentRange() {
                if (this.parameterizedValue != null) {
                    if (this.ranges == null) {
                        this.ranges = new ArrayList<Headers.AcceptLanguage.LanguageRange>();
                    }
                    this.ranges.add(new LanguageRange(this.parameterizedValue, this.weight));
                }
                this.parameters = null;
                this.weight = 1.0f;
            }

            @Override
            public Builder parameterizedValue(String parameterizedValue) {
                this.addCurrentRange();
                this.parameterizedValue = parameterizedValue;
                return this;
            }

            @Override
            public Builder parameter(String name, String value) {
                if (name.equals("q")) {
                    this.weight = (float)((int)(Float.parseFloat(value) * 1000.0f)) / 1000.0f;
                    if (this.weight == 0.0f) {
                        throw new NotAcceptableException("Invalid weight: " + this.weight);
                    }
                }
                return this;
            }

            @Override
            public AcceptLanguage build() {
                this.addCurrentRange();
                return new AcceptLanguage(this.headerValue, this.ranges);
            }
        }
    }
}

