/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.header;

import io.inverno.core.annotation.Bean;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.header.SetCookie;
import io.inverno.mod.http.base.internal.header.ParameterizedHeader;
import io.inverno.mod.http.base.internal.header.ParameterizedHeaderCodec;
import java.time.ZonedDateTime;
import java.util.Map;
import java.util.Set;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class SetCookieCodec
extends ParameterizedHeaderCodec<SetCookie, SetCookie.Builder> {
    public SetCookieCodec() {
        super(SetCookie.Builder::new, Set.of("set-cookie"), ';', ';', ',', true, true, true, true, false, false);
    }

    @Override
    public String encodeValue(SetCookie headerField) {
        StringBuilder result = new StringBuilder();
        result.append(headerField.getName()).append("=").append(headerField.getValue());
        if (headerField.getExpires() != null) {
            result.append("; ").append("Expires").append("=").append(headerField.getExpires().format(Headers.FORMATTER_RFC_5322_DATE_TIME));
        }
        if (headerField.getMaxAge() != null) {
            result.append("; ").append("Max-Age").append("=").append(headerField.getMaxAge());
        }
        if (headerField.getDomain() != null) {
            result.append("; ").append("Domain").append("=").append(headerField.getDomain());
        }
        if (headerField.getPath() != null) {
            result.append("; ").append("Path").append("=").append(headerField.getPath());
        }
        if (headerField.isSecure() != null && headerField.isSecure().booleanValue()) {
            result.append("; ").append("Secure");
        }
        if (headerField.isHttpOnly() != null && headerField.isHttpOnly().booleanValue()) {
            result.append("; ").append("HttpOnly");
        }
        if (headerField.getSameSite() != null) {
            result.append("; ").append("SameSite").append("=").append((Object)headerField.getSameSite());
        }
        return result.toString();
    }

    public static final class SetCookie
    extends ParameterizedHeader
    implements Headers.SetCookie,
    io.inverno.mod.http.base.header.SetCookie,
    SetCookie.Configurator {
        private String name;
        private String value;
        private ZonedDateTime expires;
        private Integer maxAge;
        private String domain;
        private String path;
        private Boolean secure;
        private Boolean httpOnly;
        private SetCookie.SameSitePolicy sameSite;

        public SetCookie() {
            super("set-cookie", null, null, null);
        }

        private SetCookie(String headerValue, String name, String value, ZonedDateTime expires, Integer maxAge, String domain, String path, Boolean secure, Boolean httpOnly, SetCookie.SameSitePolicy sameSite, Map<String, String> parameters) {
            super("set-cookie", headerValue, null, parameters);
            this.name = name;
            this.value = value;
            this.expires = expires;
            this.maxAge = maxAge;
            this.domain = domain;
            this.path = path;
            this.secure = secure;
            this.httpOnly = httpOnly;
            this.sameSite = sameSite;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public ZonedDateTime getExpires() {
            return this.expires;
        }

        @Override
        public Integer getMaxAge() {
            return this.maxAge;
        }

        @Override
        public String getDomain() {
            return this.domain;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public Boolean isSecure() {
            return this.secure;
        }

        @Override
        public Boolean isHttpOnly() {
            return this.httpOnly;
        }

        @Override
        public SetCookie.SameSitePolicy getSameSite() {
            return this.sameSite;
        }

        @Override
        public SetCookie.Configurator name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public SetCookie.Configurator value(String value) {
            this.value = value;
            return this;
        }

        @Override
        public SetCookie.Configurator expires(ZonedDateTime expires) {
            this.expires = expires;
            return this;
        }

        @Override
        public SetCookie.Configurator maxAge(int maxAge) {
            this.maxAge = maxAge;
            return this;
        }

        @Override
        public SetCookie.Configurator domain(String domain) {
            this.domain = domain;
            return this;
        }

        @Override
        public SetCookie.Configurator path(String path) {
            this.path = path;
            return this;
        }

        @Override
        public SetCookie.Configurator secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        @Override
        public SetCookie.Configurator httpOnly(boolean httpOnly) {
            this.httpOnly = httpOnly;
            return this;
        }

        @Override
        public SetCookie.Configurator sameSite(SetCookie.SameSitePolicy sameSite) {
            this.sameSite = sameSite;
            return this;
        }

        public static final class Builder
        extends ParameterizedHeader.AbstractBuilder<SetCookie, Builder> {
            private String name;
            private String value;
            private ZonedDateTime expires;
            private Integer maxAge;
            private String domain;
            private String path;
            private Boolean secure;
            private Boolean httpOnly;
            private SetCookie.SameSitePolicy sameSite;
            private boolean expectCookiePair = true;

            @Override
            public Builder parameter(String name, String value) {
                if (this.expectCookiePair) {
                    this.name = name;
                    this.value = value;
                    this.expectCookiePair = false;
                    return this;
                }
                if (name.equalsIgnoreCase("Expires")) {
                    this.expires = ZonedDateTime.parse(value, Headers.FORMATTER_RFC_5322_DATE_TIME);
                }
                if (name.equalsIgnoreCase("Max-Age")) {
                    this.maxAge = Integer.parseInt(value);
                }
                if (name.equalsIgnoreCase("Domain")) {
                    this.domain = value;
                }
                if (name.equalsIgnoreCase("Path")) {
                    this.path = value;
                }
                if (name.equalsIgnoreCase("Secure")) {
                    this.secure = true;
                }
                if (name.equalsIgnoreCase("HttpOnly")) {
                    this.httpOnly = true;
                }
                if (name.equalsIgnoreCase("SameSite")) {
                    this.sameSite = SetCookie.SameSitePolicy.fromValue(value);
                }
                return (Builder)super.parameter(name, value);
            }

            @Override
            public SetCookie build() {
                return new SetCookie(this.headerValue, this.name, this.value, this.expires, this.maxAge, this.domain, this.path, this.secure, this.httpOnly, this.sameSite, this.parameters);
            }
        }
    }
}

