/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.header;

import io.inverno.mod.http.base.header.Cookie;
import java.time.ZonedDateTime;

public interface SetCookie
extends Cookie {
    public ZonedDateTime getExpires();

    public Integer getMaxAge();

    public String getDomain();

    public String getPath();

    public Boolean isSecure();

    public Boolean isHttpOnly();

    public SameSitePolicy getSameSite();

    public static interface Configurator {
        public Configurator name(String var1);

        public Configurator value(String var1);

        public Configurator expires(ZonedDateTime var1);

        public Configurator maxAge(int var1);

        public Configurator domain(String var1);

        public Configurator path(String var1);

        public Configurator secure(boolean var1);

        public Configurator httpOnly(boolean var1);

        public Configurator sameSite(SameSitePolicy var1);
    }

    public static enum SameSitePolicy {
        LAX("Lax"),
        STRICT("Strict"),
        NONE("None");

        private final String value;

        private SameSitePolicy(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static SameSitePolicy fromValue(String value) throws IllegalArgumentException {
            switch (value) {
                case "Lax": {
                    return LAX;
                }
                case "Strict": {
                    return STRICT;
                }
                case "None": {
                    return NONE;
                }
            }
            throw new IllegalArgumentException("Unknown same site policy: " + value);
        }
    }
}

