/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.header;

import io.inverno.mod.http.base.header.Header;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;

public interface HeaderService {
    public <T extends Header> T decode(String var1);

    public <T extends Header> T decode(ByteBuf var1, Charset var2);

    public <T extends Header> T decode(String var1, String var2);

    public <T extends Header> T decode(String var1, ByteBuf var2, Charset var3);

    public <T extends Header> String encode(T var1);

    public <T extends Header> void encode(T var1, ByteBuf var2, Charset var3);

    public <T extends Header> String encodeValue(T var1);

    public <T extends Header> void encodeValue(T var1, ByteBuf var2, Charset var3);

    public static boolean isTokenCharacter(char character) {
        return Character.isLetterOrDigit(character) || character == '!' || character == '#' || character == '$' || character == '%' || character == '\'' || character == '*' || character == '+' || character == '-' || character == '.' || character == '^' || character == '_' || character == '`' || character == '|' || character == '~';
    }

    public static boolean isToken(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            if (HeaderService.isTokenCharacter(value.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isB64TokenCharacter(char character) {
        return Character.isLetterOrDigit(character) || character == '-' || character == '.' || character == '_' || character == '~' || character == '+' || character == '/';
    }

    public static boolean isB64Token(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        for (int i = 0; i < value.length(); ++i) {
            if (HeaderService.isB64TokenCharacter(value.charAt(i))) continue;
            if (value.charAt(i) == '=') {
                while (i < value.length()) {
                    if (value.charAt(i) != '=') {
                        return false;
                    }
                    ++i;
                }
                continue;
            }
            return false;
        }
        return true;
    }

    public static boolean isContentCharacter(char character) {
        return character > '\u001f' && character < '\u007f' || character == '\t';
    }

    public static boolean isContent(String value) {
        if (value == null || value.length() == 0) {
            return false;
        }
        byte[] valueBytes = value.getBytes();
        for (int i = 0; i < valueBytes.length; ++i) {
            if (HeaderService.isContentCharacter(value.charAt(i))) continue;
            return false;
        }
        return true;
    }
}

