/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base;

public enum Status {
    CONTINUE(100, "Continue", Category.INFORMATIONAL),
    SWITCHING_PROTOCOLS(101, "Switching Protocols", Category.INFORMATIONAL),
    OK(200, "OK", Category.SUCCESSUL),
    CREATED(201, "Created", Category.SUCCESSUL),
    ACCEPTED(202, "Accepted", Category.SUCCESSUL),
    NON_AUTHORITATIVE_INFORMATION(203, "Non-Authoritative Information", Category.SUCCESSUL),
    NO_CONTENT(204, "No Content", Category.SUCCESSUL),
    RESET_CONTENT(205, "Reset Content", Category.SUCCESSUL),
    PARTIAL_CONTENT(206, "Partial Content", Category.SUCCESSUL),
    MULTIPLE_CHOICES(300, "Multiple Choices", Category.REDIRECTION),
    MOVED_PERMANENTLY(301, "Moved Permanently", Category.REDIRECTION),
    FOUND(302, "Found", Category.REDIRECTION),
    SEE_OTHER(303, "See Other", Category.REDIRECTION),
    NOT_MODIFIED(304, "Not Modified", Category.REDIRECTION),
    USE_PROXY(305, "Use Proxy", Category.REDIRECTION),
    TEMPORARY_REDIRECT(307, "Temporary Redirect", Category.REDIRECTION),
    BAD_REQUEST(400, "Bad Request", Category.CLIENT_ERROR),
    UNAUTHORIZED(401, "Unauthorized", Category.CLIENT_ERROR),
    PAYMENT_REQUIRED(402, "Payment Required", Category.CLIENT_ERROR),
    FORBIDDEN(403, "Forbidden", Category.CLIENT_ERROR),
    NOT_FOUND(404, "Not Found", Category.CLIENT_ERROR),
    METHOD_NOT_ALLOWED(405, "Method Not Allowed", Category.CLIENT_ERROR),
    NOT_ACCEPTABLE(406, "Not Acceptable", Category.CLIENT_ERROR),
    PROXY_AUTHENTICATION_REQUIRED(407, "Proxy Authentication Required", Category.CLIENT_ERROR),
    REQUEST_TIMEOUT(408, "Request Timeout", Category.CLIENT_ERROR),
    CONFLICT(409, "Conflict", Category.CLIENT_ERROR),
    GONE(410, "Gone", Category.CLIENT_ERROR),
    LENGTH_REQUIRED(411, "Length Required", Category.CLIENT_ERROR),
    PRECONDITION_FAILED(412, "Precondition Failed", Category.CLIENT_ERROR),
    PAYLOAD_TOO_LARGE(413, "Payload Too Large", Category.CLIENT_ERROR),
    URI_TOO_LONG(414, "URI Too Long", Category.CLIENT_ERROR),
    UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type", Category.CLIENT_ERROR),
    RANGE_NOT_SATISFIABLE(416, "Range Not Satisfiable", Category.CLIENT_ERROR),
    EXPECTATION_FAILED(417, "Expectation Failed", Category.CLIENT_ERROR),
    UPGRADE_REQUIRED(426, "Upgrade Required", Category.CLIENT_ERROR),
    INTERNAL_SERVER_ERROR(500, "Internal Server Error", Category.SERVER_ERROR),
    NOT_IMPLEMENTED(501, "Not Implemented", Category.SERVER_ERROR),
    BAD_GATEWAY(502, "Bad Gateway", Category.SERVER_ERROR),
    SERVICE_UNAVAILABLE(503, "Service Unavailable", Category.SERVER_ERROR),
    GATEWAY_TIMEOUT(504, "Gateway Timeout", Category.SERVER_ERROR),
    HTTP_VERSION_NOT_SUPPORTED(505, "HTTP Version Not Supported", Category.SERVER_ERROR);

    private final int code;
    private final String reasonPhrase;
    private final Category category;

    private Status(int code, String reasonPhrase, Category category) {
        this.code = code;
        this.reasonPhrase = reasonPhrase;
        this.category = category;
    }

    public int getCode() {
        return this.code;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public Category getCategory() {
        return this.category;
    }

    public static Status valueOf(int code) {
        for (Status status : Status.values()) {
            if (status.getCode() != code) continue;
            return status;
        }
        throw new IllegalArgumentException("No enum constant for status code: " + code);
    }

    public static enum Category {
        INFORMATIONAL(1),
        SUCCESSUL(2),
        REDIRECTION(3),
        CLIENT_ERROR(4),
        SERVER_ERROR(5);

        private byte categoryId;

        private Category(byte categoryId) {
            this.categoryId = categoryId;
        }

        public static Category valueOf(int statusCode) {
            int statusCategoryId = statusCode / 100;
            for (Category category : Category.values()) {
                if (category.categoryId != statusCategoryId) continue;
                return category;
            }
            throw new IllegalArgumentException("No enum constant for status code: " + statusCode);
        }

        public static Category valueOf(Status status) {
            return Category.valueOf(status.getCode());
        }
    }
}

