/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.header;

import io.inverno.core.annotation.Bean;
import io.inverno.core.annotation.BeanSocket;
import io.inverno.mod.base.Charsets;
import io.inverno.mod.http.base.header.Header;
import io.inverno.mod.http.base.header.HeaderCodec;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.internal.header.GenericHeaderCodec;
import io.inverno.mod.http.base.internal.header.MalformedHeaderException;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;

@Bean(name="headerService")
public class GenericHeaderService
implements HeaderService {
    private Map<String, HeaderCodec<?>> codecs;
    private HeaderCodec<?> defaultCodec;

    @BeanSocket
    public GenericHeaderService() throws IllegalStateException {
        this(null);
    }

    public GenericHeaderService(List<HeaderCodec<?>> codecs) throws IllegalArgumentException {
        this.setHeaderCodecs(codecs);
        this.defaultCodec = this.codecs.get("*");
        if (this.defaultCodec == null) {
            this.defaultCodec = new GenericHeaderCodec();
        }
    }

    public void setHeaderCodecs(List<HeaderCodec<?>> codecs) {
        this.codecs = new HashMap();
        if (codecs != null) {
            for (HeaderCodec<?> codec : codecs) {
                for (String supportedHeaderName : codec.getSupportedHeaderNames()) {
                    HeaderCodec<?> previousCodec = this.codecs.put(supportedHeaderName = supportedHeaderName.toLowerCase(), codec);
                    if (previousCodec == null) continue;
                    throw new IllegalArgumentException("Multiple codecs found for header " + supportedHeaderName + ": " + previousCodec.toString() + ", " + codec.toString());
                }
            }
        }
    }

    @Override
    public <T extends Header> T decode(String header) {
        String[] nameValue = this.splitNameValue(header);
        if (nameValue == null) {
            return null;
        }
        return (T)this.getHeaderCodec(nameValue[0]).orElse(this.defaultCodec).decode(nameValue[0], nameValue[1]);
    }

    @Override
    public <T extends Header> T decode(ByteBuf buffer, Charset charset) {
        int readerIndex = buffer.readerIndex();
        Charset charsetOrDefault = Charsets.orDefault((Charset)charset);
        String name = this.readName(buffer, charsetOrDefault);
        if (name == null) {
            return null;
        }
        Object result = this.getHeaderCodec(name).orElse(this.defaultCodec).decode(name, buffer, charsetOrDefault);
        if (result == null) {
            buffer.readerIndex(readerIndex);
        }
        return (T)result;
    }

    @Override
    public <T extends Header> String encode(T header) {
        return this.getHeaderCodec(header.getHeaderName()).orElse(this.defaultCodec).encode(header);
    }

    @Override
    public <T extends Header> void encode(T header, ByteBuf buffer, Charset charset) {
        Charset charsetOrDefault = Charsets.orDefault((Charset)charset);
        this.getHeaderCodec(header.getHeaderName()).orElse(this.defaultCodec).encode(header, buffer, charsetOrDefault);
    }

    @Override
    public <T extends Header> T decode(String name, String value) {
        return (T)this.getHeaderCodec(name).orElse(this.defaultCodec).decode(name, value);
    }

    @Override
    public <T extends Header> T decode(String name, ByteBuf buffer, Charset charset) {
        return (T)this.getHeaderCodec(name).orElse(this.defaultCodec).decode(name, buffer, charset);
    }

    @Override
    public <T extends Header> String encodeValue(T header) {
        return this.getHeaderCodec(header.getHeaderName()).orElse(this.defaultCodec).encodeValue(header);
    }

    @Override
    public <T extends Header> void encodeValue(T header, ByteBuf buffer, Charset charset) {
        Charset charsetOrDefault = Charsets.orDefault((Charset)charset);
        this.getHeaderCodec(header.getHeaderName()).orElse(this.defaultCodec).encodeValue(header, buffer, charsetOrDefault);
    }

    public <T extends Header> Optional<HeaderCodec<T>> getHeaderCodec(String name) {
        return Optional.ofNullable(this.codecs.get(name));
    }

    private String readName(ByteBuf buffer, Charset charset) {
        int readerIndex = buffer.readerIndex();
        Integer startIndex = null;
        Integer endIndex = null;
        while (buffer.isReadable()) {
            byte nextByte = buffer.readByte();
            if (startIndex == null && Character.isWhitespace(nextByte)) continue;
            if (startIndex == null) {
                startIndex = buffer.readerIndex() - 1;
            }
            if (nextByte == 58) {
                endIndex = buffer.readerIndex() - 1;
                if (startIndex == endIndex) {
                    buffer.readerIndex(readerIndex);
                    throw new MalformedHeaderException("Malformed Header: empty name");
                }
                return buffer.slice(startIndex.intValue(), endIndex - startIndex).toString(charset).toLowerCase();
            }
            if (Character.isWhitespace(nextByte)) {
                buffer.readerIndex(readerIndex);
                throw new MalformedHeaderException("Malformed Header: name can't contain white space");
            }
            if (HeaderService.isTokenCharacter((char)nextByte)) continue;
            buffer.readerIndex(readerIndex);
            throw new MalformedHeaderException("Malformed Header: " + (buffer.readerIndex() - 1) + " " + buffer.toString(Charsets.UTF_8) + " " + String.valueOf(Character.toChars(nextByte)));
        }
        buffer.readerIndex(readerIndex);
        return null;
    }

    private String[] splitNameValue(String header) {
        Integer startIndex = null;
        Integer endIndex = null;
        for (int i = 0; i < header.length(); ++i) {
            char nextChar = header.charAt(i);
            if (startIndex == null && Character.isWhitespace(nextChar)) continue;
            if (startIndex == null) {
                startIndex = i;
            }
            if (nextChar == ':') {
                endIndex = i;
                if (startIndex == endIndex) {
                    throw new MalformedHeaderException("Malformed Header: empty name");
                }
                return new String[]{header.substring(startIndex, endIndex).toLowerCase(), header.substring(i + 1)};
            }
            if (Character.isWhitespace(nextChar)) {
                throw new MalformedHeaderException("Malformed Header: name can't contain white space");
            }
            if (HeaderService.isTokenCharacter(nextChar)) continue;
            throw new MalformedHeaderException("Malformed Header: " + i + " " + header + " " + nextChar);
        }
        return null;
    }

    @Bean(name="headerCodecs")
    public static interface HeaderCodecsSocket
    extends Supplier<List<HeaderCodec<?>>> {
    }
}

