/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.header;

import io.inverno.mod.http.base.header.AbstractHeaderCodec;
import io.inverno.mod.http.base.header.HeaderService;
import io.inverno.mod.http.base.internal.header.GenericHeader;
import io.inverno.mod.http.base.internal.header.MalformedHeaderException;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;
import java.util.Set;

public class GenericHeaderCodec
extends AbstractHeaderCodec<GenericHeader, GenericHeader.Builder> {
    protected GenericHeaderCodec() {
        super(GenericHeader.Builder::new, Set.of("*"));
    }

    @Override
    public GenericHeader decode(String name, String value) {
        return ((GenericHeader.Builder)((GenericHeader.Builder)((GenericHeader.Builder)this.builderSupplier.get()).headerName(name)).headerValue(value)).build();
    }

    @Override
    public GenericHeader decode(String name, ByteBuf buffer, Charset charset) {
        int readerIndex = buffer.readerIndex();
        GenericHeader.Builder builder = (GenericHeader.Builder)((GenericHeader.Builder)this.builderSupplier.get()).headerName(name);
        Integer startIndex = null;
        Integer endIndex = null;
        while (buffer.isReadable()) {
            byte nextByte = buffer.readByte();
            if (startIndex == null && Character.isWhitespace(nextByte)) continue;
            if (startIndex == null) {
                startIndex = buffer.readerIndex() - 1;
            }
            if (nextByte == 13) {
                if (buffer.getByte(buffer.readerIndex()) != 10) continue;
                buffer.readByte();
                endIndex = buffer.readerIndex() - 2;
                if (startIndex == endIndex) {
                    buffer.readerIndex(readerIndex);
                    throw new MalformedHeaderException(name);
                }
                return ((GenericHeader.Builder)builder.headerValue(buffer.slice(startIndex.intValue(), endIndex - startIndex).toString(charset))).build();
            }
            if (nextByte == 10) {
                endIndex = buffer.readerIndex() - 1;
                return ((GenericHeader.Builder)builder.headerValue(buffer.slice(startIndex.intValue(), endIndex - startIndex).toString(charset))).build();
            }
            if (HeaderService.isContentCharacter((char)nextByte)) continue;
            throw new MalformedHeaderException(name + ": Invalid character " + (char)nextByte);
        }
        buffer.readerIndex(readerIndex);
        return null;
    }

    @Override
    public String encode(GenericHeader headerField) {
        StringBuilder result = new StringBuilder();
        result.append(headerField.getHeaderName()).append(": ").append(this.encodeValue(headerField));
        return result.toString();
    }

    @Override
    public String encodeValue(GenericHeader headerField) {
        return headerField.getHeaderValue();
    }
}

