/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base.internal.header;

import io.inverno.core.annotation.Bean;
import io.inverno.mod.base.converter.ObjectConverter;
import io.inverno.mod.http.base.header.CookieParameter;
import io.inverno.mod.http.base.header.Headers;
import io.inverno.mod.http.base.internal.header.GenericCookieParameter;
import io.inverno.mod.http.base.internal.header.ParameterizedHeader;
import io.inverno.mod.http.base.internal.header.ParameterizedHeaderCodec;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

@Bean(visibility=Bean.Visibility.PRIVATE)
public class CookieCodec
extends ParameterizedHeaderCodec<Cookie, Cookie.Builder> {
    public CookieCodec(ObjectConverter<String> parameterConverter) {
        super(() -> new Cookie.Builder(parameterConverter), Set.of("cookie"), ';', ',', true, true, false, false, false, false);
    }

    @Override
    public String encodeValue(Cookie headerField) {
        return headerField.getPairs().values().stream().flatMap(Collection::stream).map(cookie -> cookie.getName() + "=" + cookie.getValue()).collect(Collectors.joining("; "));
    }

    public static final class Cookie
    extends ParameterizedHeader
    implements Headers.Cookie {
        private Map<String, List<CookieParameter>> pairs;

        private Cookie(String headerName, String headerValue, Map<String, String> parameters, Map<String, List<CookieParameter>> pairs) {
            super("cookie", headerValue, null, parameters);
            this.pairs = pairs != null ? Collections.unmodifiableMap(pairs) : Map.of();
        }

        @Override
        public Map<String, List<CookieParameter>> getPairs() {
            return this.pairs;
        }

        public static final class Builder
        extends ParameterizedHeader.AbstractBuilder<Cookie, Builder> {
            private ObjectConverter<String> parameterConverter;
            private Map<String, List<CookieParameter>> pairs;

            public Builder(ObjectConverter<String> parameterConverter) {
                this.parameterConverter = parameterConverter;
            }

            @Override
            public Builder parameter(String name, String value) {
                if (this.pairs == null) {
                    this.pairs = new HashMap<String, List<CookieParameter>>();
                }
                if (!this.pairs.containsKey(name)) {
                    this.pairs.put(name, new LinkedList());
                }
                this.pairs.get(name).add(new GenericCookieParameter(this.parameterConverter, name, value));
                return this;
            }

            @Override
            public Cookie build() {
                return new Cookie(this.headerName, this.headerValue, this.parameters, this.pairs);
            }
        }
    }
}

