/*
 * Decompiled with CFR 0.152.
 */
package io.inverno.mod.http.base;

import io.inverno.mod.http.base.HttpException;
import io.inverno.mod.http.base.Status;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;

public class ServiceUnavailableException
extends HttpException {
    private static final long serialVersionUID = -7765924553702627055L;
    private Optional<ZonedDateTime> retryAfter;

    public ServiceUnavailableException() {
        super(Status.SERVICE_UNAVAILABLE);
        this.retryAfter = Optional.empty();
    }

    public ServiceUnavailableException(String message) {
        super(Status.SERVICE_UNAVAILABLE, message);
        this.retryAfter = Optional.empty();
    }

    public ServiceUnavailableException(Throwable cause) {
        super(Status.SERVICE_UNAVAILABLE, cause);
        this.retryAfter = Optional.empty();
    }

    public ServiceUnavailableException(String message, Throwable cause) {
        super(Status.SERVICE_UNAVAILABLE, message, cause);
        this.retryAfter = Optional.empty();
    }

    public ServiceUnavailableException(long retryAfter) {
        super(Status.SERVICE_UNAVAILABLE);
        this.setRetryAfter(retryAfter);
    }

    public ServiceUnavailableException(long retryAfter, String message) {
        super(Status.SERVICE_UNAVAILABLE, message);
        this.setRetryAfter(retryAfter);
    }

    public ServiceUnavailableException(long retryAfter, Throwable cause) {
        super(Status.SERVICE_UNAVAILABLE, cause);
        this.setRetryAfter(retryAfter);
    }

    public ServiceUnavailableException(long retryAfter, String message, Throwable cause) {
        super(Status.SERVICE_UNAVAILABLE, message, cause);
        this.setRetryAfter(retryAfter);
    }

    public ServiceUnavailableException(ZonedDateTime retryAfter) {
        super(Status.SERVICE_UNAVAILABLE);
        this.setRetryAfter(retryAfter);
    }

    public ServiceUnavailableException(ZonedDateTime retryAfter, String message) {
        super(Status.SERVICE_UNAVAILABLE, message);
        this.setRetryAfter(retryAfter);
    }

    public ServiceUnavailableException(ZonedDateTime retryAfter, Throwable cause) {
        super(Status.SERVICE_UNAVAILABLE, cause);
        this.setRetryAfter(retryAfter);
    }

    public ServiceUnavailableException(ZonedDateTime retryAfter, String message, Throwable cause) {
        super(Status.SERVICE_UNAVAILABLE, message, cause);
        this.setRetryAfter(retryAfter);
    }

    private void setRetryAfter(long retryAfter) {
        this.retryAfter = Optional.of(ZonedDateTime.now().plus(retryAfter, ChronoUnit.SECONDS));
    }

    private void setRetryAfter(ZonedDateTime retryAfter) {
        if (retryAfter.isBefore(ZonedDateTime.now())) {
            throw new IllegalArgumentException("Can't retry in the past: " + retryAfter);
        }
        this.retryAfter = Optional.of(retryAfter);
    }

    public Optional<ZonedDateTime> getRetryAfter() {
        return this.retryAfter;
    }
}

